/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.vinery.core.Vinery;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MuleModel<T extends AbstractHorse>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Vinery.identifier("trader_mule"), "main");
    private static final float DEG_125 = 2.1816616f;
    private static final float DEG_60 = 1.0471976f;
    private static final float DEG_45 = 0.7853982f;
    private static final float DEG_30 = 0.5235988f;
    private static final float DEG_15 = 0.2617994f;
    protected static final String HEAD_PARTS = "head_parts";
    private static final String LEFT_HIND_BABY_LEG = "left_hind_baby_leg";
    private static final String RIGHT_HIND_BABY_LEG = "right_hind_baby_leg";
    private static final String LEFT_FRONT_BABY_LEG = "left_front_baby_leg";
    private static final String RIGHT_FRONT_BABY_LEG = "right_front_baby_leg";
    private static final String SADDLE = "saddle";
    private static final String LEFT_SADDLE_MOUTH = "left_saddle_mouth";
    private static final String LEFT_SADDLE_LINE = "left_saddle_line";
    private static final String RIGHT_SADDLE_MOUTH = "right_saddle_mouth";
    private static final String RIGHT_SADDLE_LINE = "right_saddle_line";
    private static final String HEAD_SADDLE = "head_saddle";
    private static final String MOUTH_SADDLE_WRAP = "mouth_saddle_wrap";
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart tail;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public MuleModel(ModelPart modelPart) {
        super(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f);
        this.body = modelPart.m_171324_("body");
        this.headParts = modelPart.m_171324_(HEAD_PARTS);
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.rightHindBabyLeg = modelPart.m_171324_(RIGHT_HIND_BABY_LEG);
        this.leftHindBabyLeg = modelPart.m_171324_(LEFT_HIND_BABY_LEG);
        this.rightFrontBabyLeg = modelPart.m_171324_(RIGHT_FRONT_BABY_LEG);
        this.leftFrontBabyLeg = modelPart.m_171324_(LEFT_FRONT_BABY_LEG);
        this.tail = this.body.m_171324_("tail");
        ModelPart modelPart2 = this.body.m_171324_(SADDLE);
        ModelPart modelPart3 = this.headParts.m_171324_(LEFT_SADDLE_MOUTH);
        ModelPart modelPart4 = this.headParts.m_171324_(RIGHT_SADDLE_MOUTH);
        ModelPart modelPart5 = this.headParts.m_171324_(LEFT_SADDLE_LINE);
        ModelPart modelPart6 = this.headParts.m_171324_(RIGHT_SADDLE_LINE);
        ModelPart modelPart7 = this.headParts.m_171324_(HEAD_SADDLE);
        ModelPart modelPart8 = this.headParts.m_171324_(MOUTH_SADDLE_WRAP);
        this.saddleParts = new ModelPart[]{modelPart2, modelPart3, modelPart4, modelPart7, modelPart8};
        this.ridingParts = new ModelPart[]{modelPart5, modelPart6};
    }

    public static LayerDefinition getTexturedModelData() {
        CubeDeformation cubeDeformation = new CubeDeformation(0.0f);
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition2 = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-5.0f, -8.0f, -20.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.0f)).m_171514_(0, 84).m_171488_(-8.0f, -14.0f, -3.0f, 16.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-11.0f, -9.0f, -13.0f, 6.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(32, 64).m_171488_(5.0f, -9.0f, -13.0f, 6.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)9.0f));
        PartDefinition partDefinition3 = partDefinition.m_171599_(HEAD_PARTS, CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition partDefinition4 = partDefinition3.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(56, 36).m_171488_(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_("upper_mouth", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        CubeDeformation cubeDeformation2 = cubeDeformation.m_171471_(0.0f, 5.5f, 0.0f);
        partDefinition.m_171599_(LEFT_HIND_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_(RIGHT_HIND_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_(LEFT_FRONT_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.m_171599_(RIGHT_FRONT_BABY_LEG, CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        partDefinition2.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(42, 36).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)2.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition2.m_171599_(SADDLE, CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        partDefinition3.m_171599_(LEFT_SADDLE_MOUTH, CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_(RIGHT_SADDLE_MOUTH, CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition3.m_171599_(LEFT_SADDLE_LINE, CubeListBuilder.m_171558_().m_171514_(32, 2).m_171481_(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition3.m_171599_(RIGHT_SADDLE_LINE, CubeListBuilder.m_171558_().m_171514_(32, 2).m_171481_(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        partDefinition3.m_171599_(HEAD_SADDLE, CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.f_171404_);
        partDefinition3.m_171599_(MOUTH_SADDLE_WRAP, CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        partDefinition4.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(19, 16).m_171488_(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        partDefinition4.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(19, 16).m_171488_(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public void setupAnim(T abstractHorse, float f, float g, float h, float i, float j) {
        boolean bl = abstractHorse.m_6254_();
        boolean bl2 = abstractHorse.m_20160_();
        for (ModelPart modelPart : this.saddleParts) {
            modelPart.f_104207_ = bl;
        }
        for (ModelPart modelPart : this.ridingParts) {
            modelPart.f_104207_ = bl2 && bl;
        }
        this.body.f_104201_ = 11.0f;
    }

    @NotNull
    public Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.headParts);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void prepareMobModel(T abstractHorse, float f, float g, float h) {
        super.m_6839_(abstractHorse, f, g, h);
        float i = Mth.m_14189_((float)h, (float)((AbstractHorse)abstractHorse).f_20884_, (float)((AbstractHorse)abstractHorse).f_20883_);
        float j = Mth.m_14189_((float)h, (float)((AbstractHorse)abstractHorse).f_20886_, (float)((AbstractHorse)abstractHorse).f_20885_);
        float k = Mth.m_14179_((float)h, (float)((AbstractHorse)abstractHorse).f_19860_, (float)abstractHorse.m_146909_());
        float l = j - i;
        float m = k * ((float)Math.PI / 180);
        if (l > 20.0f) {
            l = 20.0f;
        }
        if (l < -20.0f) {
            l = -20.0f;
        }
        if (g > 0.2f) {
            m += Mth.m_14089_((float)(f * 0.8f)) * 0.15f * g;
        }
        float n = abstractHorse.m_30663_(h);
        float o = abstractHorse.m_30667_(h);
        float p = 1.0f - o;
        float q = abstractHorse.m_30533_(h);
        boolean bl = ((AbstractHorse)abstractHorse).f_30517_ != 0;
        float r = (float)((AbstractHorse)abstractHorse).f_19797_ + h;
        this.headParts.f_104201_ = 4.0f;
        this.headParts.f_104202_ = -12.0f;
        this.body.f_104203_ = 0.0f;
        this.headParts.f_104203_ = 0.5235988f + m;
        this.headParts.f_104204_ = l * ((float)Math.PI / 180);
        float s = abstractHorse.m_20069_() ? 0.2f : 1.0f;
        float t = Mth.m_14089_((float)(s * f * 0.6662f + (float)Math.PI));
        float u = t * 0.8f * g;
        float v = (1.0f - Math.max(o, n)) * (0.5235988f + m + q * Mth.m_14031_((float)r) * 0.05f);
        this.headParts.f_104203_ = o * (0.2617994f + m) + n * (2.1816616f + Mth.m_14031_((float)r) * 0.05f) + v;
        this.headParts.f_104204_ = o * l * ((float)Math.PI / 180) + (1.0f - Math.max(o, n)) * this.headParts.f_104204_;
        this.headParts.f_104201_ = o * -4.0f + n * 11.0f + (1.0f - Math.max(o, n)) * this.headParts.f_104201_;
        this.headParts.f_104202_ = o * -4.0f + n * -12.0f + (1.0f - Math.max(o, n)) * this.headParts.f_104202_;
        this.body.f_104203_ = o * -0.7853982f + p * this.body.f_104203_;
        float w = 0.2617994f * o;
        float x = Mth.m_14089_((float)(r * 0.6f + (float)Math.PI));
        this.leftFrontLeg.f_104201_ = 2.0f * o + 14.0f * p;
        this.leftFrontLeg.f_104202_ = -6.0f * o - 10.0f * p;
        this.rightFrontLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.rightFrontLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        float y = (-1.0471976f + x) * o + u * p;
        float z = (-1.0471976f - x) * o - u * p;
        this.leftHindLeg.f_104203_ = w - t * 0.5f * g * p;
        this.rightHindLeg.f_104203_ = w + t * 0.5f * g * p;
        this.leftFrontLeg.f_104203_ = y;
        this.rightFrontLeg.f_104203_ = z;
        this.tail.f_104203_ = 0.5235988f + g * 0.75f;
        this.tail.f_104201_ = -5.0f + g;
        this.tail.f_104202_ = 2.0f + g * 2.0f;
        this.tail.f_104204_ = bl ? Mth.m_14089_((float)(r * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.f_104201_ = this.rightHindLeg.f_104201_;
        this.rightHindBabyLeg.f_104202_ = this.rightHindLeg.f_104202_;
        this.rightHindBabyLeg.f_104203_ = this.rightHindLeg.f_104203_;
        this.leftHindBabyLeg.f_104201_ = this.leftHindLeg.f_104201_;
        this.leftHindBabyLeg.f_104202_ = this.leftHindLeg.f_104202_;
        this.leftHindBabyLeg.f_104203_ = this.leftHindLeg.f_104203_;
        this.rightFrontBabyLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.rightFrontBabyLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.rightFrontBabyLeg.f_104203_ = this.rightFrontLeg.f_104203_;
        this.leftFrontBabyLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.leftFrontBabyLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        this.leftFrontBabyLeg.f_104203_ = this.leftFrontLeg.f_104203_;
        boolean bl2 = abstractHorse.m_6162_();
        this.rightHindLeg.f_104207_ = !bl2;
        this.leftHindLeg.f_104207_ = !bl2;
        this.rightFrontLeg.f_104207_ = !bl2;
        this.leftFrontLeg.f_104207_ = !bl2;
        this.rightHindBabyLeg.f_104207_ = bl2;
        this.leftHindBabyLeg.f_104207_ = bl2;
        this.rightFrontBabyLeg.f_104207_ = bl2;
        this.leftFrontBabyLeg.f_104207_ = bl2;
        this.body.f_104201_ = bl2 ? 10.8f : 0.0f;
    }
}

