/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import net.satisfy.vinery.core.util.ImplementedInventory;
import net.satisfy.vinery.core.util.JuiceUtil;
import net.satisfy.vinery.core.util.WineYears;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelBlockEntity
extends BlockEntity
implements ImplementedInventory,
MenuProvider {
    private static final int INVENTORY_SIZE = 6;
    public static final int GRAPEJUICE_INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT_GENERAL = 5;
    public static final int WINE_BOTTLE_SLOT = 4;
    private NonNullList<ItemStack> inventory;
    private int fermentationTime = 0;
    private int fluidLevel = 0;
    private String juiceType = "";
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> FermentationBarrelBlockEntity.this.fermentationTime;
                case 1 -> PlatformHelper.getTotalFermentationTime();
                case 2 -> FermentationBarrelBlockEntity.this.fluidLevel;
                case 3 -> FermentationBarrelBlockEntity.this.getJuiceTypeValue();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FermentationBarrelBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    FermentationBarrelBlockEntity.this.updateTotalFermentationTime();
                    break;
                }
                case 2: {
                    FermentationBarrelBlockEntity.this.setFluidLevel(value);
                    break;
                }
                case 3: {
                    FermentationBarrelBlockEntity.this.juiceType = FermentationBarrelBlockEntity.this.getJuiceTypeFromValue(value);
                    break;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public FermentationBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FERMENTATION_BARREL_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    }

    public void updateTotalFermentationTime() {
        this.m_6596_();
    }

    public int getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(int fluidLevel) {
        this.fluidLevel = fluidLevel;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public String getJuiceType() {
        return this.juiceType;
    }

    public void setJuiceType(String juiceType) {
        this.juiceType = juiceType;
        this.m_6596_();
    }

    private int getJuiceTypeValue() {
        return switch (this.juiceType) {
            case "white_general" -> 0;
            case "red_general" -> 1;
            case "white_savanna" -> 2;
            case "red_savanna" -> 3;
            case "white_taiga" -> 4;
            case "red_taiga" -> 5;
            case "white_jungle" -> 6;
            case "red_jungle" -> 7;
            case "apple" -> 8;
            case "red_crimson" -> 9;
            case "white_warped" -> 10;
            default -> -1;
        };
    }

    private String getJuiceTypeFromValue(int value) {
        return switch (value) {
            case 0 -> "white_general";
            case 1 -> "red_general";
            case 2 -> "white_savanna";
            case 3 -> "red_savanna";
            case 4 -> "white_taiga";
            case 5 -> "red_taiga";
            case 6 -> "white_jungle";
            case 7 -> "red_jungle";
            case 8 -> "apple";
            case 9 -> "red_crimson";
            case 10 -> "white_warped";
            default -> "";
        };
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128451_("FermentationTime");
        this.fluidLevel = nbt.m_128451_("FluidLevel");
        this.juiceType = nbt.m_128461_("JuiceType");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("FermentationTime", this.fermentationTime);
        nbt.m_128405_("FluidLevel", this.fluidLevel);
        nbt.m_128359_("JuiceType", this.juiceType);
    }

    public static void tick(Level world, BlockPos pos, FermentationBarrelBlockEntity blockEntity) {
        ItemStack stack;
        if (world.f_46443_) {
            return;
        }
        if (blockEntity.fluidLevel == 0) {
            blockEntity.setJuiceType("");
        }
        RegistryAccess access = world.m_9598_();
        FermentationBarrelRecipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get(), (Container)blockEntity, world).orElse(null);
        if (blockEntity.canCraft(recipe, access)) {
            ++blockEntity.fermentationTime;
            if (blockEntity.fermentationTime >= PlatformHelper.getTotalFermentationTime()) {
                blockEntity.fermentationTime = 0;
                blockEntity.craft(recipe, access);
            }
        } else {
            blockEntity.fermentationTime = 0;
        }
        if (JuiceUtil.isJuice(stack = blockEntity.m_8020_(0))) {
            String newJuiceType = JuiceUtil.getJuiceType(stack);
            if (blockEntity.fluidLevel == 0 || blockEntity.juiceType.equals(newJuiceType)) {
                blockEntity.setJuiceType(newJuiceType);
                int currentLevel = blockEntity.getFluidLevel();
                int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
                int juiceCount = stack.m_41613_();
                int juicesToConsume = Math.min(juiceCount, 4);
                int fluidIncrease = juicesToConsume * PlatformHelper.getMaxFluidIncrease();
                int newFluidLevel = Math.min(currentLevel + fluidIncrease, maxFluidLevel);
                int actualFluidIncrease = newFluidLevel - currentLevel;
                int actualJuicesConsumed = actualFluidIncrease / PlatformHelper.getMaxFluidIncrease();
                if (actualJuicesConsumed > 0) {
                    blockEntity.setFluidLevel(newFluidLevel);
                    stack.m_41774_(actualJuicesConsumed);
                    if (stack.m_41619_()) {
                        blockEntity.m_6836_(0, ItemStack.f_41583_);
                    } else {
                        blockEntity.m_6836_(0, stack);
                    }
                    ItemStack wineBottleStack = new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get(), actualJuicesConsumed);
                    ItemStack existingOutput = blockEntity.m_8020_(4);
                    if (existingOutput.m_41619_()) {
                        blockEntity.m_6836_(4, wineBottleStack);
                    } else if (existingOutput.m_150930_(wineBottleStack.m_41720_()) && existingOutput.m_41613_() + wineBottleStack.m_41613_() <= existingOutput.m_41741_()) {
                        existingOutput.m_41769_(wineBottleStack.m_41613_());
                        blockEntity.m_6836_(4, existingOutput);
                    } else {
                        Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + 0.5), (ItemStack)wineBottleStack);
                    }
                }
            }
        }
    }

    private boolean canCraft(FermentationBarrelRecipe recipe, RegistryAccess access) {
        ItemStack wineBottle;
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        if (this.areIngredientsEmpty()) {
            return false;
        }
        if (this.fluidLevel < recipe.getJuiceAmount()) {
            return false;
        }
        if (!this.juiceType.equals(recipe.getJuiceType())) {
            return false;
        }
        if (recipe.isWineBottleRequired() && ((wineBottle = this.m_8020_(4)).m_41619_() || !wineBottle.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        ItemStack recipeOutput = recipe.m_8043_(access);
        if (recipeOutput.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get())) {
            ItemStack existingWineBottle = this.m_8020_(4);
            if (existingWineBottle.m_41619_()) {
                return true;
            }
            return existingWineBottle.m_150930_(recipeOutput.m_41720_()) && existingWineBottle.m_41613_() + recipeOutput.m_41613_() <= existingWineBottle.m_41741_();
        }
        ItemStack existingOutput = this.m_8020_(5);
        if (existingOutput.m_41619_()) {
            return true;
        }
        return existingOutput.m_150930_(recipeOutput.m_41720_()) && existingOutput.m_41613_() + recipeOutput.m_41613_() <= existingOutput.m_41741_();
    }

    private boolean areIngredientsEmpty() {
        for (int i = 1; i < 4; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void craft(FermentationBarrelRecipe recipe, RegistryAccess access) {
        ItemStack wineBottle;
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access).m_41777_();
        ItemStack existingOutput = this.m_8020_(5);
        if (existingOutput.m_41619_()) {
            this.m_6836_(5, recipeOutput);
        } else if (existingOutput.m_150930_(recipeOutput.m_41720_()) && existingOutput.m_41613_() + recipeOutput.m_41613_() <= existingOutput.m_41741_()) {
            existingOutput.m_41769_(recipeOutput.m_41613_());
            this.m_6836_(5, existingOutput);
        } else {
            assert (this.f_58857_ != null);
            Containers.m_18992_((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)(this.f_58858_.m_123342_() + 1), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)recipeOutput);
        }
        if (recipe.isWineBottleRequired() && !(wineBottle = this.m_8020_(4)).m_41619_() && wineBottle.m_41613_() > 0) {
            wineBottle.m_41774_(1);
            this.m_6836_(4, wineBottle);
        }
        int newFluidLevel = this.fluidLevel - recipe.getJuiceAmount();
        this.setFluidLevel(newFluidLevel);
        block0: for (Ingredient ingredient : recipe.m_7527_()) {
            for (int i = 1; i < 4; ++i) {
                ItemStack slotStack = this.m_8020_(i);
                if (!ingredient.test(slotStack)) continue;
                slotStack.m_41774_(1);
                if (slotStack.m_41619_()) {
                    this.m_6836_(i, ItemStack.f_41583_);
                    continue block0;
                }
                this.m_6836_(i, slotStack);
                continue block0;
            }
        }
        WineYears.setWineYear(recipeOutput, this.f_58857_);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean sameItem = !stack.m_41619_() && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!sameItem && this.isIngredientSlot(slot) && this.areIngredientsEmpty()) {
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    private boolean isIngredientSlot(int slot) {
        return slot >= 1 && slot <= 3;
    }

    @Override
    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new FermentationBarrelGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }

    @Override
    public int m_6643_() {
        return this.inventory.size();
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    @Override
    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.inventory, (int)index, (int)count);
    }

    @Override
    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventory, (int)index);
    }

    @Override
    public void m_6211_() {
        this.inventory.clear();
    }

    private boolean isIngredient(ItemStack stack) {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side == Direction.UP) {
            return new int[]{0, 4};
        }
        if (side == Direction.DOWN) {
            return new int[]{5};
        }
        if (side.m_122434_().m_122479_()) {
            return new int[]{5, 4, 1, 2, 3};
        }
        return new int[0];
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.UP) {
            if (index == 0 && JuiceUtil.isJuice(stack)) {
                return this.hasSpace(index, stack);
            }
            if (index == 4 && stack.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get())) {
                return this.hasSpace(index, stack);
            }
        } else {
            assert (direction != null);
            if (direction.m_122434_().m_122479_()) {
                if (index >= 1 && index <= 3 && this.isIngredient(stack)) {
                    return this.hasSpace(index, stack);
                }
                if (index == 4 && stack.m_150930_((Item)ObjectRegistry.WINE_BOTTLE.get())) {
                    return this.hasSpace(index, stack);
                }
            }
        }
        return false;
    }

    private boolean hasSpace(int index, ItemStack stack) {
        ItemStack slotStack = this.m_8020_(index);
        if (slotStack.m_41619_()) {
            return true;
        }
        if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack)) {
            return slotStack.m_41613_() + stack.m_41613_() <= slotStack.m_41741_();
        }
        return false;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return (direction == Direction.DOWN || direction.m_122434_().m_122479_()) && index == 5;
    }
}

