/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loader.impl.metadata.NestedJarEntry;
import net.minecraftforge.fml.loading.ClasspathLocatorUtils;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModProvider;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.IModProvider;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.ConnectorUtil;
import org.sinytra.connector.loader.ConnectorEarlyLoader;
import org.sinytra.connector.loader.ConnectorLoaderModMetadata;
import org.sinytra.connector.locator.ConnectorModMetadataParser;
import org.sinytra.connector.locator.DependencyResolver;
import org.sinytra.connector.locator.ForgeModPackageFilter;
import org.sinytra.connector.locator.SplitPackageMerger;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.slf4j.Logger;

public class ConnectorLocator
extends AbstractJarFileModProvider
implements IDependencyLocator {
    private static final String NAME = "connector_locator";
    private static final String SUFFIX = ".jar";
    private static final String PLACEHOLDER_PROPERTY = "connector:placeholder";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MethodHandle MJM_INIT = (MethodHandle)LamdbaExceptionUtils.uncheck(() -> MethodHandles.privateLookupIn(ModJarMetadata.class, MethodHandles.lookup()).findConstructor(ModJarMetadata.class, MethodType.methodType(Void.TYPE)));

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        if (ConnectorEarlyLoader.hasEncounteredException()) {
            LOGGER.error("Skipping mod scan due to previously encountered error");
            return List.of();
        }
        try {
            List<IModFile> list = this.locateFabricMods(loadedMods);
            return list;
        }
        catch (EarlyLoadingException e) {
            ConnectorEarlyLoader.addGenericLoadingException(e);
        }
        catch (Throwable t) {
            StartupNotificationManager.addModMessage((String)"CONNECTOR LOCATOR ERROR");
            ConnectorEarlyLoader.addGenericLoadingException(ConnectorEarlyLoader.createGenericLoadingException(t, "Fabric mod discovery failed"));
        }
        finally {
            ForgeModPackageFilter.filterPackages(loadedMods);
        }
        return List.of();
    }

    private List<IModFile> locateFabricMods(Iterable<IModFile> discoveredMods) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)FMLPaths.MODSDIR.get());
        Path tempDir = ConnectorUtil.CONNECTOR_FOLDER.resolve("temp");
        List<SimpleModInfo> loadedModInfos = StreamSupport.stream(discoveredMods.spliterator(), false).flatMap(modFile -> Optional.ofNullable(modFile.getModFileInfo()).stream()).flatMap(modFileInfo -> {
            IModFile modFile = modFileInfo.getFile();
            List modInfos = modFileInfo.getMods();
            if (modFileInfo.getFileProperties().containsKey(PLACEHOLDER_PROPERTY)) {
                modInfos.forEach(mod -> mod.getVersion().parseVersion("0.0"));
                return Stream.empty();
            }
            if (!modInfos.isEmpty()) {
                return modInfos.stream().map(modInfo -> new SimpleModInfo(modInfo.getModId(), modInfo.getVersion(), false, modFile));
            }
            String version = modFileInfo.getFile().getSecureJar().moduleDataProvider().descriptor().version().map(ModuleDescriptor.Version::toString).orElse("0.0");
            return Stream.of(new SimpleModInfo(modFileInfo.moduleName(), (ArtifactVersion)new DefaultArtifactVersion(version), true, modFile));
        }).toList();
        List<IModFile> loadedModFiles = loadedModInfos.stream().map(SimpleModInfo::origin).toList();
        Collection loadedModIds = loadedModInfos.stream().filter(mod -> !mod.library()).map(SimpleModInfo::modid).collect(Collectors.toUnmodifiableSet());
        List excluded = ModDirTransformerDiscoverer.allExcluded();
        List<JarTransformer.TransformableJar> discoveredJars = Stream.of(this.scanModsDir(excluded), this.scanClasspath(), this.scanFromArguments(excluded)).flatMap(s -> s).map(LamdbaExceptionUtils.rethrowFunction(p -> JarTransformer.cacheTransformableJar(p.toFile()))).filter(jar -> {
            ConnectorLoaderModMetadata metadata = jar.modPath().metadata().modMetadata();
            return !ConnectorLocator.shouldIgnoreMod(metadata, loadedModIds);
        }).toList();
        HashMultimap parentToChildren = HashMultimap.create();
        List<JarTransformer.TransformableJar> discoveredNestedJars = discoveredJars.stream().flatMap(arg_0 -> ConnectorLocator.lambda$locateFabricMods$9(loadedModIds, tempDir, (Multimap)parentToChildren, arg_0)).toList();
        ArrayList ignoredModFiles = new ArrayList();
        List<JarTransformer.TransformableJar> uniqueJars = ConnectorLocator.handleDuplicateMods(discoveredJars, discoveredNestedJars, loadedModInfos, ignoredModFiles);
        List<JarTransformer.TransformableJar> candidates = DependencyResolver.resolveDependencies(uniqueJars, (Multimap<JarTransformer.TransformableJar, JarTransformer.TransformableJar>)parentToChildren, loadedModFiles);
        List<Path> renameLibs = loadedModFiles.stream().map(modFile -> modFile.getSecureJar().getRootPath()).toList();
        List<JarTransformer.FabricModPath> transformed = JarTransformer.transform(candidates, renameLibs, loadedModFiles);
        if (ConnectorEarlyLoader.hasEncounteredException()) {
            StartupNotificationManager.addModMessage((String)"JAR TRANSFORMATION ERROR");
            LOGGER.error("Cancelling jar discovery due to previous error");
            return List.of();
        }
        List<SplitPackageMerger.FilteredModPath> moduleSafeJars = SplitPackageMerger.mergeSplitPackages(transformed, loadedModFiles, ignoredModFiles);
        ArrayList<IModFile> modFiles = new ArrayList<IModFile>(moduleSafeJars.stream().map(this::createConnectorModFile).toList());
        Path generatedAdapterJar = JarTransformer.getGeneratedJarPath();
        if (Files.exists(generatedAdapterJar, new LinkOption[0])) {
            modFiles.add(this.createModOrThrow(generatedAdapterJar));
        }
        return modFiles;
    }

    private Stream<Path> scanModsDir(List<Path> excluded) {
        return this.filterPaths((Stream)LamdbaExceptionUtils.uncheck(() -> Files.list(FMLPaths.MODSDIR.get())), excluded);
    }

    private Stream<Path> filterPaths(Stream<Path> stream, List<Path> excluded) {
        return stream.filter(p -> !excluded.contains(p) && StringUtils.toLowerCase((String)p.getFileName().toString()).endsWith(SUFFIX)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase((String)path.getFileName().toString()))).filter(ConnectorLocator::isFabricModJar);
    }

    private Stream<Path> scanClasspath() {
        if (FMLEnvironment.production) {
            return Stream.of(new Path[0]);
        }
        try {
            ArrayList<Path> claimed = new ArrayList<Path>(Arrays.stream(System.getProperty("legacyClassPath", "").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList());
            Stream.Builder<Path> ret = Stream.builder();
            Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources("fabric.mod.json");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Path path = ClasspathLocatorUtils.findJarPathFor((String)"fabric.mod.json", (String)"fabric.mod.json", (URL)url);
                if (!claimed.stream().noneMatch(path::equals) || !Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !ConnectorLocator.isFabricModJar(path)) continue;
                ret.add(path);
            }
            return ret.build();
        }
        catch (IOException e) {
            LOGGER.error(LogMarkers.SCAN, "Error trying to find resources", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Stream<Path> scanFromArguments(List<Path> excluded) {
        String[] paths = System.getProperty("connector.additionalModLocations", "").split(",");
        if (paths.length == 0) {
            return Stream.of(new Path[0]);
        }
        Stream.Builder files = Stream.builder();
        Arrays.stream(paths).filter(s -> !s.isBlank()).map(x$0 -> Path.of(x$0, new String[0])).forEach(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                ((Stream)LamdbaExceptionUtils.uncheck(() -> Files.list(path))).forEach(files::add);
            } else {
                files.add(path);
            }
        });
        return this.filterPaths(files.build(), excluded);
    }

    private IModFile createConnectorModFile(SplitPackageMerger.FilteredModPath modPath) {
        ModJarMetadata mjm = ConnectorUtil.uncheckThrowable(() -> MJM_INIT.invoke());
        SecureJar modJar = SecureJar.from(Manifest::new, jar -> mjm, modPath.filter(), (Path[])modPath.paths());
        ModFile mod = new ModFile(modJar, (IModProvider)this, modFile -> ConnectorModMetadataParser.createForgeMetadata(modFile, modPath.metadata().modMetadata(), modPath.metadata().generated()));
        mjm.setModFile((IModFile)mod);
        return mod;
    }

    private IModFile createModOrThrow(Path ... paths) {
        IModLocator.ModFileOrException moe = this.createMod(paths);
        if (moe.ex() != null) {
            throw new RuntimeException("Failed to create mod file for paths " + Arrays.toString(paths), (Throwable)moe.ex());
        }
        return moe.file();
    }

    private static boolean isFabricModJar(Path path) {
        SecureJar secureJar = SecureJar.from((Path[])new Path[]{path});
        String name = secureJar.name();
        Path modsToml = secureJar.getPath("META-INF/mods.toml", new String[0]);
        if (Files.exists(modsToml, new LinkOption[0]) && !ConnectorLocator.containsPlaceholder(modsToml)) {
            LOGGER.debug(LogMarkers.SCAN, "Skipping jar {} as it contains a mods.toml file", (Object)path);
            return false;
        }
        if (secureJar.moduleDataProvider().findFile("fabric.mod.json").isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod: {}", (Object)"fabric.mod.json", (Object)path);
            return true;
        }
        LOGGER.info(LogMarkers.SCAN, "Fabric mod metadata not found in jar {}, ignoring", (Object)name);
        return false;
    }

    private static boolean containsPlaceholder(Path modsTomlPath) {
        try {
            FileConfig fileConfig = FileConfig.of((Path)modsTomlPath);
            fileConfig.load();
            fileConfig.close();
            NightConfigWrapper config = new NightConfigWrapper((UnmodifiableConfig)fileConfig);
            return config.getConfigElement(new String[]{"properties"}).map(map -> map.containsKey(PLACEHOLDER_PROPERTY)).orElse(false);
        }
        catch (Throwable t) {
            LOGGER.error("Error reading placeholder information from {}", (Object)modsTomlPath, (Object)t);
            return false;
        }
    }

    private static Stream<JarTransformer.TransformableJar> discoverNestedJarsRecursive(Path tempDir, JarTransformer.TransformableJar parent, Collection<NestedJarEntry> jars, Multimap<JarTransformer.TransformableJar, JarTransformer.TransformableJar> parentToChildren, Collection<String> loadedModIds) {
        SecureJar secureJar = SecureJar.from((Path[])new Path[]{parent.input().toPath()});
        return jars.stream().map(entry -> secureJar.getPath(entry.getFile(), new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(path -> {
            JarTransformer.TransformableJar jar = (JarTransformer.TransformableJar)LamdbaExceptionUtils.uncheck(() -> ConnectorLocator.prepareNestedJar(tempDir, secureJar.getPrimaryPath().getFileName().toString(), path));
            ConnectorLoaderModMetadata metadata = jar.modPath().metadata().modMetadata();
            if (ConnectorLocator.shouldIgnoreMod(metadata, loadedModIds)) {
                return Stream.empty();
            }
            parentToChildren.put((Object)parent, (Object)jar);
            return Stream.concat(Stream.of(jar), ConnectorLocator.discoverNestedJarsRecursive(tempDir, jar, metadata.getJars(), parentToChildren, loadedModIds));
        });
    }

    private static JarTransformer.TransformableJar prepareNestedJar(Path tempDir, String parentName, Path path) throws IOException {
        Files.createDirectories(tempDir, new FileAttribute[0]);
        String parentNameWithoutExt = parentName.split("\\.(?!.*\\.)")[0];
        Path extracted = tempDir.resolve(parentNameWithoutExt + "$" + path.getFileName().toString());
        ConnectorUtil.cache(path, extracted, () -> Files.copy(path, extracted, new CopyOption[0]));
        return (JarTransformer.TransformableJar)LamdbaExceptionUtils.uncheck(() -> JarTransformer.cacheTransformableJar(extracted.toFile()));
    }

    private static List<JarTransformer.TransformableJar> handleDuplicateMods(List<JarTransformer.TransformableJar> rootMods, List<JarTransformer.TransformableJar> nestedMods, Collection<SimpleModInfo> loadedMods, Collection<? super IModFile> ignoredModFiles) {
        return Stream.concat(rootMods.stream(), nestedMods.stream()).filter(jar -> {
            DefaultArtifactVersion artifactVersion;
            SimpleModInfo fabricModInfo;
            List<SimpleModInfo> modsByVersion;
            String id = jar.modPath().metadata().modMetadata().getId();
            List<SimpleModInfo> forgeMods = loadedMods.stream().filter(mod -> mod.modid().equals(id)).toList();
            if (forgeMods.stream().anyMatch(SimpleModInfo::library) && (modsByVersion = Stream.concat(Stream.of(fabricModInfo = new SimpleModInfo(id, (ArtifactVersion)(artifactVersion = new DefaultArtifactVersion(jar.modPath().metadata().modMetadata().getVersion().getFriendlyString())), false, null)), forgeMods.stream()).sorted(Comparator.comparing(SimpleModInfo::version).reversed()).toList()).get(0) == fabricModInfo) {
                modsByVersion.subList(1, modsByVersion.size()).forEach(mod -> {
                    IModFile modFile = Objects.requireNonNull(mod.origin(), "Missing mod origin for mod " + mod.modid());
                    ignoredModFiles.add(modFile);
                });
                return true;
            }
            if (loadedMods.stream().anyMatch(mod -> mod.modid().equals(id))) {
                LOGGER.info(LogMarkers.SCAN, "Removing duplicate mod {} in file {}", (Object)id, (Object)jar.modPath().path().toAbsolutePath());
                return false;
            }
            return true;
        }).toList();
    }

    private static boolean shouldIgnoreMod(ConnectorLoaderModMetadata metadata, Collection<String> loadedModIds) {
        String id = metadata.getId();
        return ConnectorUtil.DISABLED_MODS.contains(id) || loadedModIds.contains(id);
    }

    public String name() {
        return NAME;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    private static /* synthetic */ Stream lambda$locateFabricMods$9(Collection loadedModIds, Path tempDir, Multimap parentToChildren, JarTransformer.TransformableJar jar) {
        ConnectorLoaderModMetadata metadata = jar.modPath().metadata().modMetadata();
        return ConnectorLocator.shouldIgnoreMod(metadata, loadedModIds) ? Stream.empty() : ConnectorLocator.discoverNestedJarsRecursive(tempDir, jar, metadata.getJars(), (Multimap<JarTransformer.TransformableJar, JarTransformer.TransformableJar>)parentToChildren, loadedModIds);
    }

    private record SimpleModInfo(String modid, ArtifactVersion version, boolean library, @Nullable IModFile origin) {
    }
}

