/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.events.ClientEvents;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonBallExplosion
extends Explosion {
    private final BlockPos centerPos;
    private final float maxExplodedAmount;
    @Nullable
    private final Set<Block> whitelist;
    private float explosionAmountLeft;

    public CannonBallExplosion(Level level, @Nullable Entity source, double toBlowX, double toBlowY, double toBlowZ, BlockPos centerPos, float maxExplodedAmount, float maxRadius, @Nullable Set<Block> whitelist) {
        super(level, source, toBlowX, toBlowY, toBlowZ, maxRadius, false, Explosion.BlockInteraction.DESTROY);
        this.centerPos = centerPos;
        this.maxExplodedAmount = maxExplodedAmount;
        this.whitelist = maxRadius == 0.0f ? Set.of() : whitelist;
    }

    public CannonBallExplosion(Level level, @Nullable Entity source, double toBlowX, double toBlowY, double toBlowZ, float radius, List<BlockPos> toBlow) {
        super(level, source, toBlowX, toBlowY, toBlowZ, radius, toBlow);
        this.centerPos = BlockPos.m_274446_((Position)new Vec3(toBlowX, toBlowY, toBlowZ));
        this.maxExplodedAmount = 0.0f;
        this.whitelist = null;
    }

    public void m_46061_() {
        Vec3 center = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        AtomicReference<Float> explosionBudget = new AtomicReference<Float>(Float.valueOf(this.maxExplodedAmount));
        toVisit.add(this.centerPos);
        while (!toVisit.isEmpty() && (double)explosionBudget.get().floatValue() > 0.25) {
            BlockPos currentPos = (BlockPos)toVisit.poll();
            this.visit(currentPos, center, explosionBudget, this.m_46081_(), visited, toVisit);
        }
        this.explosionAmountLeft = explosionBudget.get().floatValue();
    }

    public float getExploded() {
        return this.maxExplodedAmount - this.explosionAmountLeft;
    }

    private void visit(BlockPos pos, Vec3 center, AtomicReference<Float> explosionBudget, List<BlockPos> toExplode, Set<BlockPos> visited, Queue<BlockPos> toVisit) {
        float r = this.f_46017_ + this.f_46012_.f_46441_.m_188501_();
        if (!pos.equals((Object)this.centerPos) && center.m_82557_(pos.m_252807_()) > (double)(r * r)) {
            return;
        }
        if (!this.f_46012_.m_46739_(pos) || visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        BlockState blockState = this.f_46012_.m_8055_(pos);
        FluidState fluidState = this.f_46012_.m_6425_(pos);
        boolean canPropagateExplosion = false;
        if (!blockState.m_60795_()) {
            if (this.whitelist != null && !this.whitelist.contains(blockState.m_60734_())) {
                return;
            }
            Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, fluidState);
            if (optional.isPresent()) {
                float resistance = (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                float newB = explosionBudget.get().floatValue() - resistance;
                if (newB > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, pos, blockState, 1.0f)) {
                    toExplode.add(pos);
                    explosionBudget.set(Float.valueOf(newB));
                    canPropagateExplosion = true;
                }
            }
        }
        if (!canPropagateExplosion) {
            return;
        }
        ArrayList<BlockPos> neighborPos = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            neighborPos.add(pos.m_121945_(d));
        }
        neighborPos.sort(Comparator.comparingDouble(p -> center.m_82557_(p.m_252807_())));
        toVisit.addAll(neighborPos);
    }

    public void m_46075_(boolean spawnParticles) {
        Player player;
        LivingEntity indirectSource;
        if (this.f_46012_.f_46443_) {
            ClientEvents.onExplosion(this);
        }
        if (spawnParticles) {
            this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
        }
        boolean hasDrop = !((indirectSource = this.m_252906_()) instanceof Player && (player = (Player)indirectSource).m_7500_());
        Util.m_214673_((ObjectArrayList)((ObjectArrayList)this.m_46081_()), (RandomSource)this.f_46012_.f_46441_);
        LinkedHashMultiset sounds = LinkedHashMultiset.create();
        for (BlockPos blockPos : this.m_46081_()) {
            BlockState blockState = this.f_46012_.m_8055_(blockPos);
            if (blockState.m_60795_()) continue;
            this.destroyBlockNoEffects(blockPos, this.f_46012_, (Entity)indirectSource, 512, (Multiset<SoundEvent>)sounds);
        }
        if (this.f_46012_.f_46443_ && !sounds.isEmpty()) {
            UnmodifiableIterator iter = Multisets.copyHighestCountFirst((Multiset)sounds).iterator();
            for (int i = 0; i < 3 && iter.hasNext(); ++i) {
                SoundEvent sound = (SoundEvent)iter.next();
                this.f_46012_.m_7785_(this.f_46013_, this.f_46014_, this.f_46015_, sound, SoundSource.BLOCKS, 2.5f, 0.6f + this.f_46012_.f_46441_.m_188501_() * 0.2f, false);
            }
        }
    }

    public boolean destroyBlockNoEffects(BlockPos pos, Level level, @Nullable Entity entity, int recursionLeft, Multiset<SoundEvent> sounds) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_()) {
            return false;
        }
        FluidState fluidState = level.m_6425_(pos);
        if (level.f_46443_ && !(blockState.m_60734_() instanceof BaseFireBlock)) {
            sounds.add((Object)SuppPlatformStuff.getSoundType(blockState, pos, level, entity).m_56775_());
            level.m_142052_(pos, blockState);
        }
        BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)ItemStack.f_41583_);
        boolean bl = level.m_6933_(pos, fluidState.m_76188_(), 3, recursionLeft);
        if (bl) {
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockState));
        }
        return bl;
    }
}

