/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.brood;

import com.teamabnormals.blueprint.core.endimator.entity.EndimatedGoal;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.common.entity.eetle.EetleEgg;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleDropEggsGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleFlingGoal;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.phys.Vec3;

public class BroodEetleLaunchEggsGoal
extends EndimatedGoal<BroodEetle> {
    private int ticksOffGround;
    private int shotsToFire;
    private int ticksPassed;

    public BroodEetleLaunchEggsGoal(BroodEetle entity) {
        super((Entity)entity, EEPlayableEndimations.BROOD_EETLE_LAUNCH);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        BroodEetle broodEetle = (BroodEetle)this.entity;
        if ((broodEetle.canFireEggCannon() || broodEetle.getEggCannonCooldown() <= 200 && this.random.nextFloat() < 0.05f && BroodEetleDropEggsGoal.areFewEetlesNearby(broodEetle)) && broodEetle.hasWokenUp() && broodEetle.m_20096_() && broodEetle.isNoEndimationPlaying() && !broodEetle.isFlying()) {
            List<LivingEntity> aggressors = BroodEetleFlingGoal.searchForNearbyAggressors(broodEetle, broodEetle.m_21133_(Attributes.f_22277_) * 0.5);
            return BroodEetleLaunchEggsGoal.computeAverageAggressorDistanceSq(broodEetle.m_20182_(), aggressors) >= 42.25 || !aggressors.isEmpty() && this.random.nextFloat() < 0.01f;
        }
        return false;
    }

    public boolean m_8045_() {
        if (((BroodEetle)this.entity).m_20096_()) {
            this.ticksOffGround = 0;
        }
        return this.shotsToFire > 0 && ++this.ticksOffGround < 10;
    }

    public void m_8056_() {
        BroodEetle broodEetle = (BroodEetle)this.entity;
        broodEetle.setFiringCannon(true);
        this.shotsToFire = this.random.nextInt(3) + 5 - (int)Math.min(5.0f, (float)BroodEetleLaunchEggsGoal.getNearbyEetleCount(broodEetle) * 0.625f);
    }

    public void m_8037_() {
        ++this.ticksPassed;
        BroodEetle broodEetle = (BroodEetle)this.entity;
        if (broodEetle.isEggMouthOpen() && this.ticksPassed % 20 == 0) {
            this.playEndimation();
            Vec3 firingPos = new Vec3(-1.0, 3.0, 0.0).m_82524_(-broodEetle.f_20883_ * ((float)Math.PI / 180) - 1.5707964f);
            EetleEgg eetleEgg = new EetleEgg(broodEetle.m_9236_(), broodEetle.m_20182_().m_82549_(firingPos));
            RandomSource random = broodEetle.m_217043_();
            eetleEgg.setEggSize(EetleEgg.EggSize.random(random, true));
            eetleEgg.m_20256_(new Vec3((double)((random.m_188501_() - random.m_188501_()) * 0.35f), (double)(0.8f + random.m_188501_() * 0.1f), (double)((random.m_188501_() - random.m_188501_()) * 0.35f)));
            broodEetle.m_9236_().m_7967_((Entity)eetleEgg);
            --this.shotsToFire;
        }
    }

    public void m_8041_() {
        BroodEetle broodEetle = (BroodEetle)this.entity;
        broodEetle.setFiringCannon(false);
        broodEetle.resetEggCannonCooldown();
        this.ticksOffGround = 0;
        this.shotsToFire = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    private static double computeAverageAggressorDistanceSq(Vec3 pos, List<LivingEntity> aggressors) {
        double total = 0.0;
        for (LivingEntity livingEntity : aggressors) {
            total += pos.m_82557_(livingEntity.m_20182_());
        }
        return total / (double)aggressors.size();
    }

    public static int getNearbyEetleCount(BroodEetle broodEetle) {
        double followRange = broodEetle.m_21133_(Attributes.f_22277_);
        double posY = broodEetle.m_20186_();
        Sensing senses = broodEetle.m_21574_();
        return broodEetle.m_9236_().m_6443_(AbstractEetle.class, broodEetle.m_20191_().m_82377_(followRange, followRange * 0.75, followRange), eetle -> {
            if (eetle.m_20186_() - posY >= 0.5 && !senses.m_148306_((Entity)eetle)) {
                return false;
            }
            return eetle.m_6084_() && (!eetle.m_6162_() || eetle.getGrowingAge() >= -240);
        }).size();
    }
}

