/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.observer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.compat.computercraft.events.TrainPassEvent;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.observer.TrackObserver;
import com.simibubi.create.content.trains.observer.TrackObserverBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackObserverBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public TrackTargetingBehaviour<TrackObserver> edgePoint;
    private FilteringBehaviour filtering;
    public AbstractComputerBehaviour computerBehaviour;
    @Nullable
    public UUID passingTrainUUID;

    public TrackObserverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<TrackObserver>(this, EdgePointType.OBSERVER);
        behaviours.add(this.edgePoint);
        this.filtering = this.createFilter().withCallback(this::onFilterChanged);
        behaviours.add(this.filtering);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.filtering.setLabel(CreateLang.translateDirect("logistics.train_observer.cargo_filter", new Object[0]));
    }

    private void onFilterChanged(ItemStack newFilter) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            observer.setFilterAndNotify(this.f_58857_, newFilter);
        }
    }

    @Override
    public void tick() {
        BlockState blockState;
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean shouldBePowered = false;
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            shouldBePowered = observer.isActivated();
        }
        if (this.isBlockPowered() == shouldBePowered) {
            return;
        }
        if (observer != null && this.computerBehaviour.hasAttachedComputer()) {
            if (shouldBePowered) {
                this.passingTrainUUID = observer.getCurrentTrain();
            }
            if (this.passingTrainUUID != null) {
                this.computerBehaviour.prepareComputerEvent(new TrainPassEvent(Create.RAILWAYS.trains.get(this.passingTrainUUID), shouldBePowered));
                if (!shouldBePowered) {
                    this.passingTrainUUID = null;
                }
            }
        }
        if ((blockState = this.m_58900_()).m_61138_((Property)TrackObserverBlock.POWERED)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)TrackObserverBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
        }
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
    }

    @Nullable
    public TrackObserver getObserver() {
        return this.edgePoint.getEdgePoint();
    }

    public ItemStack getFilter() {
        return this.filtering.getFilter();
    }

    public boolean isBlockPowered() {
        return this.m_58900_().m_61145_((Property)TrackObserverBlock.POWERED).orElse(false);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_, this.edgePoint.getGlobalPosition()).m_82400_(2.0);
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(){

            @Override
            public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
                TransformStack.of((PoseStack)ms).rotateXDegrees(90.0f);
            }

            @Override
            public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
                return new Vec3(0.5, 0.96875, 0.5);
            }
        });
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.computerBehaviour.removePeripheral();
    }
}

