/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.inventory;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class VersionedInventoryWrapper
implements IItemHandlerModifiable {
    public static final AtomicInteger idGenerator = new AtomicInteger();
    private IItemHandlerModifiable inventory;
    private int version;
    private int id = idGenerator.getAndIncrement();

    public VersionedInventoryWrapper(IItemHandlerModifiable inventory) {
        this.inventory = inventory;
        this.version = 0;
    }

    public void incrementVersion() {
        ++this.version;
    }

    public int getVersion() {
        return this.version;
    }

    public int getId() {
        return this.id;
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inventory.isItemValid(slot, stack);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int count = stack.m_41613_();
        ItemStack result = this.inventory.insertItem(slot, stack, simulate);
        if (!simulate && count != result.m_41613_()) {
            this.incrementVersion();
        }
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = this.inventory.extractItem(slot, amount, simulate);
        if (!simulate && !result.m_41619_()) {
            this.incrementVersion();
        }
        return result;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack previousItem = this.inventory.getStackInSlot(slot);
        this.inventory.setStackInSlot(slot, stack);
        if (stack.m_41619_() == previousItem.m_41619_()) {
            if (stack.m_41619_()) {
                return;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)previousItem) && stack.m_41613_() == previousItem.m_41613_()) {
                return;
            }
        }
        this.incrementVersion();
    }
}

