/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.infrastructure.command.HighlightPacket;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;

public class HighlightCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"highlight").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"players");
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            for (ServerPlayer p : players) {
                AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> p), (Object)new HighlightPacket(pos));
            }
            return players.size();
        }))).executes(ctx -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)((CommandSourceStack)ctx.getSource()).m_81373_()), (Object)new HighlightPacket(pos));
            return 1;
        }))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            return HighlightCommand.highlightAssemblyExceptionFor(player, (CommandSourceStack)ctx.getSource());
        });
    }

    private static void sendMissMessage(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237113_((String)"Try looking at a Block that has failed to assemble a Contraption and try again."), true);
    }

    private static int highlightAssemblyExceptionFor(ServerPlayer player, CommandSourceStack source) {
        double distance = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        Vec3 start = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = start.m_82520_(look.f_82479_ * distance, look.f_82480_ * distance, look.f_82481_ * distance);
        Level world = player.m_9236_();
        BlockHitResult ray = world.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (ray.m_6662_() == HitResult.Type.MISS) {
            HighlightCommand.sendMissMessage(source);
            return 0;
        }
        BlockPos pos = ray.m_82425_();
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof IDisplayAssemblyExceptions)) {
            HighlightCommand.sendMissMessage(source);
            return 0;
        }
        IDisplayAssemblyExceptions display = (IDisplayAssemblyExceptions)be;
        AssemblyException exception = display.getLastAssemblyException();
        if (exception == null) {
            HighlightCommand.sendMissMessage(source);
            return 0;
        }
        if (!exception.hasPosition()) {
            source.m_288197_(() -> Component.m_237113_((String)"Can't highlight a specific position for this issue"), true);
            return 1;
        }
        BlockPos p = exception.getPosition();
        String command = "/create highlight " + p.m_123341_() + " " + p.m_123342_() + " " + p.m_123343_();
        return player.f_8924_.m_129892_().m_230957_(source, command);
    }
}

