/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import java.util.Set;
import net.mehvahdjukaar.every_compat.configs.UnsafeDisablerConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class HardcodedBlockType {
    public static String woodidentify;
    public static String woodTypeFromMod;
    public static String leavesidentify;
    public static String leavesTypeFromMod;
    public static String supportedMod;
    public static String supportedBlockName;
    private static final Set<String> VANILLA_WOODS;
    private static final Set<String> VANILLA_LEAVES;

    @Nullable
    public static Boolean isWoodBlockAlreadyRegistered(String entrySetId, String blockName, WoodType woodType, String supportedModId) {
        woodTypeFromMod = woodType.getNamespace();
        woodidentify = woodType.getId().toString();
        supportedMod = supportedModId;
        supportedBlockName = blockName;
        String blockId = supportedModId + "/" + woodTypeFromMod + "/" + blockName;
        if (HardcodedBlockType.isWoodFrom("dawnoftimebuilder", "", "minecraft:(oak|acacia|jungle|dark_oak|spruce|mangrove|cherry)", "fancy_fence").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("chipped", "", "minecraft:(acacia|birch|jungle|dark_oak|spruce|mangrove|cherry)", "\\w+_glass(_pane)?").booleanValue()) {
            return false;
        }
        if (UnsafeDisablerConfigs.WOOD_TYPES_BLACKLIST.get().stream().anyMatch(woodidentify::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.BLOCKS_BLACKLIST.get().stream().anyMatch(blockId::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.ENTRY_SETS_BLACKLIST.get().stream().anyMatch(entrySetId::matches)) {
            return true;
        }
        if (HardcodedBlockType.isKnownVanillaWood(woodType)) {
            return true;
        }
        if (HardcodedBlockType.isWoodFrom("", "", "legendarymonuments:distortion", "").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isWoodFrom("", "", "", "torch").booleanValue() && PlatHelper.isModLoaded((String)"framedblocks")) {
            return true;
        }
        if (HardcodedBlockType.isWoodFrom("valhelsia_structures", "", "natures_spirit:joshua", "").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isWoodFrom("regions_unexplored", "gardens_of_the_dead|snifferent|nethers_exoticism", "", "(whistlecane|globar|jabuticaba)_branch").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isWoodFrom("quark", "ecologics", "", "stripped_flowering_azalea_post").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isWoodFrom("branches", "", "", "branch").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("", "", "terraqueous:cherry", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("refurbished_furniture", "", "dawnoftimebuilder:waxed_oak", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("", "", "twilightforest:mangrove", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("quark", "upgrade_aquatic|autumnity|atmospheric|environmental|caverns_and_chasms", "", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("bewitchment", "betternether|betterend", "", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("", "bloomingnature|meadow", "", "window").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("architects_palette", "upgrade_aquatic", "", "driftwood_boards|river_boards").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("architects_palette", "autumnity", "", "maple_boards").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("", "tfc", "", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("quark", "", "ecologics:azalea", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("woodworks", "architects_palette", "", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isWoodFrom("architects_palette", "upgrade_aquatic|autumnity|atmospheric|environmental|caverns_and_chasms", "", "").booleanValue()) {
            return false;
        }
        return null;
    }

    @Nullable
    public static Boolean isLeavesBlockAlreadyRegistered(String entrySetId, String blockName, LeavesType leavesType, String supportedModId) {
        leavesTypeFromMod = leavesType.getNamespace();
        leavesidentify = leavesType.getId().toString();
        supportedMod = supportedModId;
        supportedBlockName = blockName;
        String blockId = supportedModId + "/" + woodTypeFromMod + "/" + blockName;
        if (UnsafeDisablerConfigs.LEAVES_TYPES_BLACKLIST.get().stream().anyMatch(leavesidentify::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.BLOCKS_BLACKLIST.get().stream().anyMatch(blockId::matches)) {
            return true;
        }
        if (UnsafeDisablerConfigs.ENTRY_SETS_BLACKLIST.get().stream().anyMatch(entrySetId::matches)) {
            return true;
        }
        if (HardcodedBlockType.isKnownVanillaLeaves(leavesType)) {
            return true;
        }
        if (HardcodedBlockType.isLeavesFrom("chipped", "chipped", "", "").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isLeavesFrom("", "", "traversable_leaves:dev_leaves", "").booleanValue()) {
            return true;
        }
        if (HardcodedBlockType.isLeavesFrom("quark", "", "alexscaves:ancient", "").booleanValue()) {
            return false;
        }
        if (HardcodedBlockType.isLeavesFrom("mcwfences|cfm", "quark", "", "").booleanValue()) {
            return false;
        }
        return null;
    }

    public static Boolean isWoodFrom(String SupportedModId, String woodtypeFromMod, String woodTypeId, String supportedBlockId) {
        String[] expressions = new String[]{SupportedModId, woodtypeFromMod, woodTypeId, supportedBlockId};
        String[] values = new String[]{supportedMod, woodTypeFromMod, woodidentify, supportedBlockName};
        for (int idx = 0; idx < values.length; ++idx) {
            boolean mismatched;
            if (expressions[idx].isEmpty()) continue;
            boolean bl = mismatched = !values[idx].matches(expressions[idx]) && !values[idx].contains(expressions[idx]);
            if (!mismatched) continue;
            return false;
        }
        return true;
    }

    public static Boolean isLeavesFrom(String whichSupportedModId, String leavestypeFromMod, String leavesTypeId, String supportedBlockId) {
        String[] expressions = new String[]{whichSupportedModId, leavestypeFromMod, leavesTypeId, supportedBlockId};
        String[] values = new String[]{supportedMod, leavesTypeFromMod, leavesidentify, supportedBlockName};
        for (int idx = 0; idx < values.length; ++idx) {
            boolean mismatched;
            if (expressions[idx].isEmpty()) continue;
            boolean bl = mismatched = !values[idx].matches(expressions[idx]) && !values[idx].contains(expressions[idx]);
            if (!mismatched) continue;
            return false;
        }
        return true;
    }

    public static boolean isKnownVanillaWood(WoodType woodType) {
        ResourceLocation id = woodType.getId();
        if (id.m_135827_().equals("minecraft")) {
            return VANILLA_WOODS.contains(id.m_135815_());
        }
        return false;
    }

    public static boolean isKnownVanillaLeaves(LeavesType leavesType) {
        ResourceLocation id = leavesType.getId();
        if (id.m_135827_().equals("minecraft")) {
            return VANILLA_LEAVES.contains(id.m_135815_());
        }
        return false;
    }

    static {
        VANILLA_WOODS = Set.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped");
        VANILLA_LEAVES = Set.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped", "azalea", "flowering_azalea");
    }
}

