/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.endergetic.client.model.purpoid.PurpModel;
import com.teamabnormals.endergetic.client.model.purpoid.PurpoidModel;
import com.teamabnormals.endergetic.client.renderer.entity.layers.PurpShielderLayer;
import com.teamabnormals.endergetic.client.renderer.entity.layers.PurpazoidStunLayer;
import com.teamabnormals.endergetic.client.renderer.entity.layers.PurpoidEmissiveLayer;
import com.teamabnormals.endergetic.client.renderer.entity.layers.PurpoidGelLayer;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.core.other.EEModelLayers;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import com.teamabnormals.endergetic.core.other.EERenderTypes;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PurpoidRenderer
extends MobRenderer<Purpoid, PurpoidModel> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("endergetic", "textures/entity/purpoid/purpoid.png"), new ResourceLocation("endergetic", "textures/entity/purpoid/purp.png"), new ResourceLocation("endergetic", "textures/entity/purpoid/purpazoid.png")};
    private final PurpoidModel[] models;

    public PurpoidRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PurpoidModel(context.m_174023_(EEModelLayers.PURPOID)), 0.6f);
        this.models = new PurpoidModel[]{(PurpoidModel)this.m_7200_(), new PurpModel(context.m_174023_(EEModelLayers.PURP)), new PurpModel(context.m_174023_(EEModelLayers.PURPAZOID))};
        this.m_115326_(new PurpoidEmissiveLayer((RenderLayerParent<Purpoid, PurpoidModel>)this));
        PurpoidGelLayer gelLayer = new PurpoidGelLayer((RenderLayerParent<Purpoid, PurpoidModel>)this, context.m_174027_());
        this.m_115326_(gelLayer);
        this.m_115326_(new PurpShielderLayer((RenderLayerParent<Purpoid, PurpoidModel>)this, this.models[2], gelLayer.getGelModel(2)));
        this.m_115326_(new PurpazoidStunLayer((RenderLayerParent<Purpoid, PurpoidModel>)this, this.models[1], gelLayer.getGelModel(1)));
    }

    public boolean shouldRender(Purpoid purpoid, Frustum frustum, double p_115470_, double p_115471_, double p_115472_) {
        return purpoid.getIDOfShieldedMommy() >= 0 || super.m_5523_((Mob)purpoid, frustum, p_115470_, p_115471_, p_115472_);
    }

    public void render(Purpoid purpoid, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        Purpoid purpoidMommy;
        this.f_115290_ = this.models[purpoid.getSize().ordinal()];
        this.f_114477_ = 0.6f * purpoid.getSize().getScale();
        super.m_7392_((Mob)purpoid, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        if (PurpoidRenderer.isInvisibleWhileTeleporting(purpoid)) {
            return;
        }
        Entity shieldedMommy = purpoid.m_9236_().m_6815_(purpoid.getIDOfShieldedMommy());
        if (shieldedMommy instanceof Purpoid && !PurpoidRenderer.isInvisibleWhileTeleporting(purpoidMommy = (Purpoid)shieldedMommy)) {
            PurpoidRenderer.renderShieldingLine(purpoid, partialTicks, poseStack, bufferIn, purpoidMommy.m_20318_(partialTicks), purpoidMommy.getStunTimer());
        }
    }

    protected void setupRotations(Purpoid purpoid, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        String name;
        Entity ridingEntity = purpoid.m_20202_();
        if (ridingEntity != null) {
            if (ridingEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)ridingEntity;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_)));
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
            }
        } else {
            Vec3 pull = purpoid.getPull(partialTicks);
            double pulledX = Mth.m_14139_((double)partialTicks, (double)purpoid.f_19854_, (double)purpoid.m_20185_()) - pull.m_7096_();
            double pulledY = Mth.m_14139_((double)partialTicks, (double)purpoid.f_19855_, (double)purpoid.m_20186_()) - pull.m_7098_();
            double pulledZ = Mth.m_14139_((double)partialTicks, (double)purpoid.f_19856_, (double)purpoid.m_20189_()) - pull.m_7094_();
            float rotationOffset = 0.5f * purpoid.getSize().getScale();
            float yRot = (float)Mth.m_14136_((double)pulledZ, (double)pulledX);
            poseStack.m_252880_(0.0f, rotationOffset, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(-yRot));
            poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(Mth.m_14136_((double)Mth.m_14116_((float)((float)(pulledX * pulledX + pulledZ * pulledZ))), (double)(-pulledY)) - Math.PI)));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(yRot));
            poseStack.m_252880_(0.0f, -rotationOffset, 0.0f);
        }
        if (purpoid.m_8077_() && ((name = ChatFormatting.m_126649_((String)purpoid.m_7755_().getString())).equals("Dinnerbone") || name.equals("Grumm"))) {
            poseStack.m_85837_(0.0, (double)purpoid.m_20206_() + 0.1, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    @Nullable
    protected RenderType getRenderType(Purpoid purpoid, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation texture = this.getTextureLocation(purpoid);
        if (p_230496_3_) {
            return RenderType.m_110467_((ResourceLocation)texture);
        }
        if (p_230496_2_) {
            return BlueprintRenderTypes.getUnshadedCutoutEntity((ResourceLocation)texture, (boolean)true);
        }
        return p_230496_4_ ? RenderType.m_110491_((ResourceLocation)texture) : null;
    }

    public ResourceLocation getTextureLocation(Purpoid entity) {
        return PurpoidRenderer.getTexture(entity.getSize().ordinal());
    }

    public static ResourceLocation getTexture(int index) {
        return TEXTURES[index];
    }

    private static boolean isInvisibleWhileTeleporting(Purpoid purpoid) {
        return (purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEPORT_TO) || purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_FAST_TELEPORT_TO)) && purpoid.getAnimationTick() >= 10;
    }

    private static void renderShieldingLine(Purpoid purpoid, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, Vec3 mommyPos, int stunTimer) {
        int i;
        stack.m_85836_();
        double interpolatedPurpoidX = Mth.m_14139_((double)partialTicks, (double)purpoid.f_19854_, (double)purpoid.m_20185_());
        double interpolatedPurpoidY = Mth.m_14139_((double)partialTicks, (double)purpoid.f_19855_, (double)purpoid.m_20186_()) + 0.25;
        double interpolatedPurpoidZ = Mth.m_14139_((double)partialTicks, (double)purpoid.f_19856_, (double)purpoid.m_20189_());
        stack.m_252880_(0.0f, 0.25f, 0.0f);
        float xDifference = (float)(mommyPos.f_82479_ - interpolatedPurpoidX);
        float yDifference = (float)(mommyPos.f_82480_ + 1.0 - interpolatedPurpoidY);
        float zDifference = (float)(mommyPos.f_82481_ - interpolatedPurpoidZ);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(EERenderTypes.PURPAZOID_SHIELDING_LINE);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float width = 0.1f;
        float widthProportionalToDistance = (float)Mth.m_14193_((double)(xDifference * xDifference + zDifference * zDifference)) * width / 2.0f;
        float zGap = zDifference * widthProportionalToDistance;
        float xGap = xDifference * widthProportionalToDistance;
        float stunTimerHalfCycles = Math.max((float)stunTimer - partialTicks, 0.0f) / 20.0f;
        float alpha = 0.1f + 0.4f * (1.0f - 2.0f * Mth.m_14154_((float)(stunTimerHalfCycles - (float)Mth.m_14143_((float)(stunTimerHalfCycles + 0.5f)))));
        float baseR = 0.643f;
        float baseG = 0.482f;
        float baseB = 0.918f;
        if (purpoid.f_20916_ > 0 || purpoid.f_20919_ > 0) {
            baseR = baseR * 0.5f + 0.5f;
            baseG *= 0.5f;
            baseB *= 0.5f;
        }
        float waveOffset = (float)Math.PI * ((float)purpoid.f_19797_ + partialTicks) / 20.0f;
        for (i = 0; i <= 48; ++i) {
            PurpoidRenderer.addShieldingLineVertexPair(vertexconsumer, matrix4f, alpha, waveOffset, baseR, baseG, baseB, xDifference, yDifference, zDifference, width, width, zGap, xGap, i, false);
        }
        for (i = 48; i >= 0; --i) {
            PurpoidRenderer.addShieldingLineVertexPair(vertexconsumer, matrix4f, alpha, waveOffset, baseR, baseG, baseB, xDifference, yDifference, zDifference, width, 0.0f, zGap, xGap, i, true);
        }
        stack.m_85849_();
    }

    private static void addShieldingLineVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float alpha, float ageInTicks, float baseR, float baseG, float baseB, float xDifference, float yDifference, float zDifference, float width, float secondaryWidth, float zGap, float xGap, int index, boolean otherLine) {
        float yProgress;
        float progress = (float)index / 48.0f;
        float colorBrightness = index % 2 == (otherLine ? 1 : 0) ? 0.5f : 1.0f;
        float r = baseR * colorBrightness;
        float g = baseG * colorBrightness;
        float b = baseB * colorBrightness;
        float progressedXDifference = xDifference * progress;
        if ((double)progress < 0.1) {
            smoothInto = progress / 0.1f;
            yProgress = (1.0f - 0.05f * smoothInto) * (-(Mth.m_14089_((float)((float)Math.PI * progress)) - 1.0f) / 2.0f) + 0.05f * smoothInto * Mth.m_14031_((float)((float)Math.PI * 10 * progress + ageInTicks));
        } else if (progress < 0.9f) {
            yProgress = 0.95f * (-(Mth.m_14089_((float)((float)Math.PI * progress)) - 1.0f) / 2.0f) + 0.05f * Mth.m_14031_((float)((float)Math.PI * 10 * progress + ageInTicks));
        } else {
            smoothInto = (progress - 0.9f) / 0.1f;
            yProgress = (0.95f + 0.05f * smoothInto) * (-(Mth.m_14089_((float)((float)Math.PI * progress)) - 1.0f) / 2.0f) + (0.05f - 0.05f * smoothInto) * Mth.m_14031_((float)((float)Math.PI * 10 * progress + ageInTicks));
        }
        float progressedYDifference = yDifference > 0.0f ? yDifference * yProgress : yDifference - yDifference * (1.0f - yProgress);
        float progressedZDifference = zDifference * progress;
        vertexConsumer.m_252986_(matrix4f, progressedXDifference - zGap, progressedYDifference + secondaryWidth, progressedZDifference + xGap).m_85950_(r, g, b, alpha).m_85969_(0xF000F0).m_5752_();
        vertexConsumer.m_252986_(matrix4f, progressedXDifference + zGap, progressedYDifference + width - secondaryWidth, progressedZDifference - xGap).m_85950_(r, g, b, alpha).m_85969_(0xF000F0).m_5752_();
    }
}

