/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.transactions.internal;

import dev.mayaqq.cynosure.transactions.DelicateTransactionApi;
import dev.mayaqq.cynosure.transactions.InnerCloseListener;
import dev.mayaqq.cynosure.transactions.OuterCloseListener;
import dev.mayaqq.cynosure.transactions.Transaction;
import dev.mayaqq.cynosure.transactions.TransactionResult;
import dev.mayaqq.cynosure.utils.result.ExtensionsKt;
import dev.mayaqq.cynosure.utils.result.OtherKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003J\u0011\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\b\u0018\u00010\rR\u00020\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0018\u00010\rR\u00020\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Ldev/mayaqq/cynosure/transactions/internal/TransactionManager;", "", "<init>", "()V", "Ldev/mayaqq/cynosure/transactions/Transaction;", "openOuter", "()Ldev/mayaqq/cynosure/transactions/Transaction;", "", "validateThread", "getCurrent", "Ljava/lang/Thread;", "thread", "Ljava/lang/Thread;", "Ldev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;", "outerTransaction", "Ldev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;", "currentTransaction", "", "Ldev/mayaqq/cynosure/transactions/OuterCloseListener;", "outerListeners", "Ljava/util/List;", "Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "getLifecycle", "()Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "lifecycle", "", "getDepth", "()I", "depth", "LinkedTransaction", "cynosure_forge"})
@SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\ndev/mayaqq/cynosure/transactions/internal/TransactionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class TransactionManager {
    @NotNull
    private final Thread thread;
    @Nullable
    private LinkedTransaction outerTransaction;
    @Nullable
    private LinkedTransaction currentTransaction;
    @NotNull
    private final List<OuterCloseListener> outerListeners;

    public TransactionManager() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        this.thread = thread;
        this.outerListeners = new ArrayList();
    }

    @NotNull
    public final Transaction.Lifecycle getLifecycle() {
        Object object = this.currentTransaction;
        if (object == null || (object = object.getLifecycle()) == null) {
            object = Transaction.Lifecycle.CLOSED;
        }
        return object;
    }

    public final int getDepth() {
        int n;
        if (this.currentTransaction == null) {
            n = -1;
        } else {
            LinkedTransaction linkedTransaction = this.currentTransaction;
            Intrinsics.checkNotNull((Object)linkedTransaction);
            n = linkedTransaction.getDepth();
        }
        return n;
    }

    @NotNull
    public final Transaction openOuter() {
        LinkedTransaction transaction;
        if (!(this.outerTransaction == null)) {
            boolean i = false;
            String string = "Attempted to open outer transaction inside another transaction";
            throw new IllegalStateException(string.toString());
        }
        this.outerTransaction = transaction = new LinkedTransaction(0, null);
        this.currentTransaction = transaction;
        transaction.setLifecycle(Transaction.Lifecycle.OPEN);
        return transaction;
    }

    public final void validateThread() {
        Thread current = Thread.currentThread();
        if (!Intrinsics.areEqual((Object)current, (Object)this.thread)) {
            boolean i = false;
            String string = "Attempted to access transation from thread " + this.thread.getName() + " on " + current.getName();
            throw new IllegalStateException(string.toString());
        }
    }

    @DelicateTransactionApi
    @Nullable
    public final Transaction getCurrent() {
        LinkedTransaction linkedTransaction;
        this.validateThread();
        LinkedTransaction linkedTransaction2 = this.currentTransaction;
        if (linkedTransaction2 != null) {
            LinkedTransaction linkedTransaction3;
            LinkedTransaction it = linkedTransaction3 = linkedTransaction2;
            boolean i = false;
            linkedTransaction = it.getLifecycle() == Transaction.Lifecycle.OPEN ? linkedTransaction3 : null;
        } else {
            linkedTransaction = null;
        }
        return linkedTransaction;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0080\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u001a\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001d8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010\t\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\t\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Ldev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;", "Ldev/mayaqq/cynosure/transactions/Transaction;", "", "nestingDepth", "Ldev/mayaqq/cynosure/transactions/internal/TransactionManager;", "parentTransaction", "<init>", "(Ldev/mayaqq/cynosure/transactions/internal/TransactionManager;ILdev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;)V", "Ldev/mayaqq/cynosure/transactions/TransactionResult;", "result", "", "close", "(Ldev/mayaqq/cynosure/transactions/TransactionResult;)V", "Ldev/mayaqq/cynosure/transactions/InnerCloseListener;", "listener", "addCloseListener", "(Ldev/mayaqq/cynosure/transactions/InnerCloseListener;)V", "Ldev/mayaqq/cynosure/transactions/OuterCloseListener;", "addOuterCloseListener", "(Ldev/mayaqq/cynosure/transactions/OuterCloseListener;)V", "depth", "get", "(I)Ldev/mayaqq/cynosure/transactions/Transaction;", "openNested", "()Ldev/mayaqq/cynosure/transactions/Transaction;", "validateCurrentTransaction", "()V", "validateOpen", "Ldev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction;", "", "listeners", "Ljava/util/List;", "Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "lifecycle", "Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "getLifecycle", "()Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;", "setLifecycle", "(Ldev/mayaqq/cynosure/transactions/Transaction$Lifecycle;)V", "value", "Ldev/mayaqq/cynosure/transactions/TransactionResult;", "getResult", "()Ldev/mayaqq/cynosure/transactions/TransactionResult;", "cynosure_forge"})
    @SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\ndev/mayaqq/cynosure/transactions/internal/TransactionManager$LinkedTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
    public final class LinkedTransaction
    extends Transaction {
        @Nullable
        private final LinkedTransaction parentTransaction;
        private List<InnerCloseListener> listeners;
        @NotNull
        private Transaction.Lifecycle lifecycle;
        @NotNull
        private TransactionResult result;

        public LinkedTransaction(@Nullable int nestingDepth, LinkedTransaction parentTransaction) {
            super(nestingDepth);
            this.parentTransaction = parentTransaction;
            this.lifecycle = Transaction.Lifecycle.CLOSED;
            this.result = TransactionResult.ABORTED;
        }

        @Override
        @NotNull
        public Transaction.Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public void setLifecycle(@NotNull Transaction.Lifecycle lifecycle) {
            Intrinsics.checkNotNullParameter((Object)((Object)lifecycle), (String)"<set-?>");
            this.lifecycle = lifecycle;
        }

        @NotNull
        public final TransactionResult getResult() {
            return this.result;
        }

        @Override
        protected void close(@NotNull TransactionResult result) {
            RuntimeException it;
            RuntimeException runtimeException;
            Object object;
            int index;
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            this.validateCurrentTransaction();
            this.validateOpen();
            this.setLifecycle(Transaction.Lifecycle.CLOSING);
            this.result = result;
            Object closeResult = null;
            closeResult = OtherKt.getUNIT(Result.Companion);
            if (this.listeners != null) {
                List<InnerCloseListener> list = this.listeners;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                    list = null;
                }
                for (index = (v35296).size(); -1 < index; --index) {
                    Object $this$close_u24lambda_u240;
                    List<InnerCloseListener> list2 = this.listeners;
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                        list2 = null;
                    }
                    object = list2.get(index);
                    try {
                        $this$close_u24lambda_u240 = object;
                        boolean i = false;
                        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dev.mayaqq.cynosure.transactions.TransactionContext");
                        $this$close_u24lambda_u240.onClose(this, result);
                        $this$close_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable i) {
                        $this$close_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)i));
                    }
                    object = $this$close_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) continue;
                    Object it2 = $this$close_u24lambda_u240 = throwable;
                    boolean k = false;
                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)closeResult);
                    if (throwable2 == null) {
                        it = runtimeException = new RuntimeException("Transaction error");
                        boolean j = false;
                        closeResult = ExtensionsKt.failure(it);
                        throwable2 = runtimeException;
                    }
                    ExceptionsKt.addSuppressed((Throwable)throwable2, (Throwable)it2);
                }
                List<InnerCloseListener> list3 = this.listeners;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                    list3 = null;
                }
                list3.clear();
            }
            if (this == TransactionManager.this.outerTransaction) {
                this.setLifecycle(Transaction.Lifecycle.OUTER_CLOSING);
                for (index = TransactionManager.this.outerListeners.size(); -1 < index; --index) {
                    Object object2;
                    object = TransactionManager.this.outerListeners.get(index);
                    try {
                        OuterCloseListener $this$close_u24lambda_u243 = (OuterCloseListener)object;
                        boolean l = false;
                        $this$close_u24lambda_u243.onOuterClose(result);
                        object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable l) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)l));
                    }
                    object = object2;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) continue;
                    Object it3 = object2 = throwable;
                    boolean n = false;
                    Throwable throwable3 = Result.exceptionOrNull-impl((Object)closeResult);
                    if (throwable3 == null) {
                        it = runtimeException = new RuntimeException("Transaction error");
                        boolean m = false;
                        closeResult = ExtensionsKt.failure(it);
                        throwable3 = runtimeException;
                    }
                    ExceptionsKt.addSuppressed((Throwable)throwable3, (Throwable)it3);
                }
                TransactionManager.this.outerTransaction = null;
                TransactionManager.this.outerListeners.clear();
            }
            TransactionManager.this.currentTransaction = this.parentTransaction;
            this.setLifecycle(Transaction.Lifecycle.CLOSED);
            Object object3 = closeResult;
            ResultKt.throwOnFailure((Object)object3);
        }

        @Override
        public void addCloseListener(@NotNull InnerCloseListener listener) {
            List<InnerCloseListener> list;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TransactionManager.this.validateThread();
            this.validateOpen();
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if ((list = this.listeners) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listeners");
                list = null;
            }
            list.add(listener);
        }

        @Override
        public void addOuterCloseListener(@NotNull OuterCloseListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TransactionManager.this.validateThread();
            TransactionManager.this.outerListeners.add(listener);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Transaction get(int depth) {
            Transaction transaction;
            TransactionManager.this.validateThread();
            int n = depth;
            if (n == this.getDepth()) {
                transaction = this;
            } else if (n == this.getDepth() - 1) {
                transaction = this.parentTransaction;
            } else {
                void var3_3;
                LinkedTransaction transaction2 = this.parentTransaction;
                while (transaction2 != null && transaction2.getDepth() != depth) {
                    transaction2 = transaction2.parentTransaction;
                }
                transaction = (Transaction)var3_3;
            }
            return transaction;
        }

        @NotNull
        public final Transaction openNested() {
            TransactionManager.this.validateThread();
            this.validateCurrentTransaction();
            LinkedTransaction transaction = new LinkedTransaction(this.getDepth() + 1, this);
            TransactionManager.this.currentTransaction = transaction;
            return transaction;
        }

        private final void validateCurrentTransaction() {
            TransactionManager.this.validateThread();
            boolean bl = this == TransactionManager.this.currentTransaction;
            TransactionManager transactionManager = TransactionManager.this;
            if (!bl) {
                boolean i = false;
                LinkedTransaction linkedTransaction = transactionManager.currentTransaction;
                String string = "Attempted to call transaction function on a transaction with depth " + this.getDepth() + " but current depth is " + (linkedTransaction != null ? Integer.valueOf(linkedTransaction.getDepth()) : null);
                throw new IllegalStateException(string.toString());
            }
        }

        private final void validateOpen() {
            if (!(this.getLifecycle() == Transaction.Lifecycle.OPEN)) {
                boolean i = false;
                String string = "Attempted to access transaction functions on a " + this.getLifecycle() + " transaction";
                throw new IllegalStateException(string.toString());
            }
        }
    }
}

