/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.event.def;

import io.github.bumblesoftware.fastload.api.event.core.AbstractEvent;
import io.github.bumblesoftware.fastload.api.event.core.EventArgs;
import io.github.bumblesoftware.fastload.api.event.core.EventHolder;
import io.github.bumblesoftware.fastload.api.event.core.EventStatus;
import io.github.bumblesoftware.fastload.util.obj_holders.MutableObjectHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;

public class CapableEvent<Context>
implements AbstractEvent<Context> {
    private final Comparator<Long> order;
    public final List<String> locationList;
    public final Object2ObjectOpenHashMap<String, EventHolder<Context>> allEvents;
    public final Object2ObjectOpenHashMap<String, EventHolder<Context>> eventsToAdd;
    public final Object2ObjectOpenHashMap<String, EventHolder<Context>> eventsToRemove;

    public CapableEvent(Comparator<Long> eventOrder) {
        this.order = eventOrder;
        this.locationList = new ArrayList<String>();
        this.allEvents = new Object2ObjectOpenHashMap();
        this.eventsToAdd = new Object2ObjectOpenHashMap();
        this.eventsToRemove = new Object2ObjectOpenHashMap();
        this.allEvents.put((Object)"generic", this.getNewHolder());
        this.eventsToAdd.put((Object)"generic", this.getNewHolder());
        this.eventsToRemove.put((Object)"generic", this.getNewHolder());
    }

    public CapableEvent() {
        this(Comparator.reverseOrder());
    }

    @Override
    public synchronized void clean() {
        this.eventsToAdd.clear();
        this.eventsToRemove.clear();
        for (String location : this.getLocationList()) {
            EventHolder eventHolder = (EventHolder)this.getStorage().get((Object)location);
            if (eventHolder == null) {
                this.getStorage().remove((Object)location);
                continue;
            }
            ArrayList<Long> emptyPriorities = new ArrayList<Long>();
            for (Long priority : eventHolder.priorityHolder()) {
                if (!((List)eventHolder.argsHolder().get(priority.longValue())).isEmpty()) continue;
                emptyPriorities.add(priority);
            }
            for (Long priority : emptyPriorities) {
                eventHolder.priorityHolder().remove(priority);
                eventHolder.argsHolder().remove(priority.longValue());
            }
        }
    }

    @Override
    public synchronized Object2ObjectOpenHashMap<String, EventHolder<Context>> getStorage() {
        return this.allEvents;
    }

    @Override
    public synchronized List<String> getLocationList() {
        return this.locationList;
    }

    @Override
    public synchronized void removeDynamic(long priority, List<String> locations, EventArgs<Context> eventArgs) {
        for (String string : locations) {
            this.eventsToRemove.putIfAbsent((Object)string, this.getNewHolder());
            EventHolder holder = (EventHolder)this.eventsToRemove.get((Object)string);
            if (!holder.priorityHolder().contains(priority)) {
                holder.priorityHolder().add(priority);
            }
            if (!holder.argsHolder().containsKey(priority)) {
                ArrayList<EventArgs<Context>> list = new ArrayList<EventArgs<Context>>();
                list.add(eventArgs);
                holder.argsHolder().put(priority, list);
                continue;
            }
            if (((List)holder.argsHolder().get(priority)).contains(eventArgs)) continue;
            ((List)holder.argsHolder().get(priority)).add(eventArgs);
        }
    }

    @Override
    public synchronized void removeStatic(long priority, List<String> locations, EventArgs<Context> eventArgs) {
        for (String string : locations) {
            EventHolder holder = (EventHolder)this.getStorage().get((Object)string);
            ((List)holder.argsHolder().get(priority)).remove(eventArgs);
            if (!((List)holder.argsHolder().get(priority)).isEmpty()) continue;
            holder.argsHolder().remove(priority);
            holder.priorityHolder().remove(priority);
        }
    }

    @Override
    public synchronized void registerDynamic(long priority, List<String> locations, EventArgs<Context> eventArgs) {
        for (String location : locations) {
            this.eventsToAdd.putIfAbsent((Object)location, this.getNewHolder());
            EventHolder holder = (EventHolder)this.eventsToAdd.get((Object)location);
            if (!holder.priorityHolder().contains(priority)) {
                holder.priorityHolder().add(priority);
            }
            if (!holder.argsHolder().containsKey(priority)) {
                ArrayList<EventArgs<Context>> list = new ArrayList<EventArgs<Context>>();
                list.add(eventArgs);
                holder.argsHolder().put(priority, list);
                continue;
            }
            if (((List)holder.argsHolder().get(priority)).contains(eventArgs)) continue;
            ((List)holder.argsHolder().get(priority)).add(eventArgs);
        }
    }

    @Override
    public synchronized void registerStatic(long priority, List<String> locations, EventArgs<Context> eventArgs) {
        for (String location : locations) {
            this.allEvents.putIfAbsent((Object)location, this.getNewHolder());
            EventHolder holder = (EventHolder)this.allEvents.get((Object)location);
            ArrayList<Long> priHol = holder.priorityHolder();
            Long2ObjectMap argHol = holder.argsHolder();
            if (!this.locationList.contains(location)) {
                this.locationList.add(location);
            }
            if (!priHol.contains(priority)) {
                priHol.add(priority);
            }
            if (!argHol.containsKey(priority)) {
                ArrayList<EventArgs<Context>> list = new ArrayList<EventArgs<Context>>();
                list.add(eventArgs);
                argHol.put(priority, list);
                continue;
            }
            if (((List)argHol.get(priority)).contains(eventArgs)) continue;
            ((List)argHol.get(priority)).add(eventArgs);
        }
    }

    private void iterate(EventHolder<Context> holder, BiConsumer<Long, EventArgs<Context>> argsIterator) {
        if (holder != null) {
            for (long priority : holder.priorityHolder()) {
                for (EventArgs arg : (List)holder.argsHolder().get(priority)) {
                    if (arg == null) continue;
                    argsIterator.accept(priority, arg);
                }
            }
        }
    }

    @Override
    public void execute(List<String> locations, boolean orderFlipped, Context eventContext) {
        MutableObjectHolder<EventStatus> statusHolder = new MutableObjectHolder<EventStatus>(EventStatus.CONTINUE);
        for (String string : locations) {
            EventHolder add = (EventHolder)this.eventsToAdd.get((Object)string);
            EventHolder all = (EventHolder)this.allEvents.get((Object)string);
            EventHolder remove = (EventHolder)this.eventsToRemove.remove((Object)string);
            Comparator<Long> order = orderFlipped ? this.order.reversed() : this.order;
            this.iterate(add, this::registerStatic);
            all.priorityHolder().sort(order);
            for (long priority : all.priorityHolder()) {
                for (EventArgs arg : (List)all.argsHolder().get(priority)) {
                    if (arg != null) {
                        arg.recursive(eventContext, statusHolder, this, 0, arg);
                    }
                    if (!statusHolder.equalsAny(List.of(EventStatus.FINISH_ALL, EventStatus.FINISH_LOCATION, EventStatus.FINISH_PRIORITY))) continue;
                    break;
                }
                if (!statusHolder.equalsAny(List.of(EventStatus.FINISH_ALL, EventStatus.FINISH_LOCATION))) continue;
                break;
            }
            if (((EventStatus)((Object)statusHolder.getHeldObj())).equals((Object)EventStatus.FINISH_ALL)) break;
            this.iterate(remove, this::removeStatic);
        }
        this.clean();
    }
}

