/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry;

import com.simibubi.create.AllFluids;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.block.DragonBreathFluidBlock;
import net.dakotapride.garnished.registry.Fluids;
import net.dakotapride.garnished.registry.GarnishedBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GarnishedFluids
implements Fluids {
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GARNISH = ((FluidBuilder)GarnishedFluids.standardFluid("garnish", SolidRenderedPlaceableFluidType.create(15722979, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/garnish")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> APPLE_CIDER = ((FluidBuilder)GarnishedFluids.standardFluid("apple_cider", SolidRenderedPlaceableFluidType.create(15709047, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/apple_cider")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PEANUT_OIL = ((FluidBuilder)GarnishedFluids.standardFluid("peanut_oil", SolidRenderedPlaceableFluidType.create(13288607, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/peanut_oil")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CASHEW_MIXTURE = ((FluidBuilder)GarnishedFluids.standardFluid("cashew_mixture", SolidRenderedPlaceableFluidType.create(0xFCEFCF, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/cashew_mixture")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MASTIC_RESIN = GarnishedFluids.masticResinRegistration("", 5401420);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> RED_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("red", 9312537);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> ORANGE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("orange", 10835502);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> YELLOW_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("yellow", 11700277);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GREEN_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("green", 4427305);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIME_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("lime", 3655238);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BLUE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("blue", 3766910);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIGHT_BLUE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("light_blue", 5352385);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CYAN_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("cyan", 5357976);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PURPLE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("purple", 5711001);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MAGENTA_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("magenta", 10563526);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PINK_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("pink", 13193357);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BLACK_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("black", 398878);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GRAY_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("gray", 0x2D333D);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> LIGHT_GRAY_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("light_gray", 7702435);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> WHITE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("white", 12633312);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BROWN_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("brown", 6374194);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> DRAGON_BREATH = ((FluidBuilder)((FluidBuilder)GarnishedFluids.standardFluid("dragon_breath", SolidRenderedPlaceableFluidType.create(12929155, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400).lightLevel(15)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).block((pProperties, pProperties2) -> new DragonBreathFluidBlock((BlockBehaviour.Properties)pProperties2)).build()).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/dragon_breath")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SWEET_TEA = ((FluidBuilder)GarnishedFluids.standardFluid("sweet_tea", SolidRenderedPlaceableFluidType.create(14847058, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400).lightLevel(15)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/sweet_tea")}).build()).register();

    private static ResourceLocation createLocation(String fluid, boolean isFlowing) {
        String getMotion = isFlowing ? "_flow" : "_still";
        return new ResourceLocation("garnished", "fluid/" + fluid + getMotion);
    }

    public static FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate> standardFluid(String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return CreateGarnished.registrate().fluid(name, GarnishedFluids.createLocation(name, false), GarnishedFluids.createLocation(name, true), typeFactory);
    }

    public static FluidEntry<ForgeFlowingFluid.Flowing> masticResinRegistration(String colour0, int colour1) {
        return ((FluidBuilder)GarnishedFluids.standardFluid((String)(colour0 == "" ? colour0 : colour0 + "_") + "mastic_resin", SolidRenderedPlaceableFluidType.create(colour1, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/mastic_resin")}).build()).register();
    }

    public static void setRegister() {
    }

    public static void registerFluidInteractions() {
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), PEANUT_OIL.getType(), Blocks.f_50080_, (Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), APPLE_CIDER.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.CARNOTITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), GARNISH.getType(), Blocks.f_50080_, (Block)AllPaletteStoneTypes.CALCITE.getBaseBlock().get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), CASHEW_MIXTURE.getType(), Blocks.f_50080_, Blocks.f_50259_);
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), RED_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.RED_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), ORANGE_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.ORANGE_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), YELLOW_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.YELLOW_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), GREEN_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.GREEN_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), LIME_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.LIME_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), BLUE_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.BLUE_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), LIGHT_BLUE_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.LIGHT_BLUE_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), CYAN_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.CYAN_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), PURPLE_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.PURPLE_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), MAGENTA_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.MAGENTA_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), PINK_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.PINK_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), BLACK_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.BLACK_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), GRAY_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.GRAY_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), LIGHT_GRAY_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.LIGHT_GRAY_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), WHITE_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.WHITE_ZULTANITE.get());
        Fluids.basicFluidInteraction((FluidType)ForgeMod.LAVA_TYPE.get(), BROWN_MASTIC_RESIN.getType(), Blocks.f_50080_, (Block)GarnishedBlocks.BROWN_ZULTANITE.get());
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluids.lavaInteraction(fluidState, (Fluid)GARNISH.get(), (Block)AllPaletteStoneTypes.CALCITE.getBaseBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)PEANUT_OIL.get(), (Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)APPLE_CIDER.get(), (Block)GarnishedBlocks.CARNOTITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)CASHEW_MIXTURE.get(), Blocks.f_50259_);
        Fluids.lavaInteraction(fluidState, (Fluid)MASTIC_RESIN.get(), (Block)GarnishedBlocks.ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)RED_MASTIC_RESIN.get(), (Block)GarnishedBlocks.RED_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)ORANGE_MASTIC_RESIN.get(), (Block)GarnishedBlocks.ORANGE_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)YELLOW_MASTIC_RESIN.get(), (Block)GarnishedBlocks.YELLOW_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)GREEN_MASTIC_RESIN.get(), (Block)GarnishedBlocks.GREEN_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)LIME_MASTIC_RESIN.get(), (Block)GarnishedBlocks.LIME_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)BLUE_MASTIC_RESIN.get(), (Block)GarnishedBlocks.BLUE_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)LIGHT_BLUE_MASTIC_RESIN.get(), (Block)GarnishedBlocks.LIGHT_BLUE_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)CYAN_MASTIC_RESIN.get(), (Block)GarnishedBlocks.CYAN_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)PURPLE_MASTIC_RESIN.get(), (Block)GarnishedBlocks.PURPLE_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)MAGENTA_MASTIC_RESIN.get(), (Block)GarnishedBlocks.MAGENTA_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)PINK_MASTIC_RESIN.get(), (Block)GarnishedBlocks.PINK_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)BLACK_MASTIC_RESIN.get(), (Block)GarnishedBlocks.BLACK_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)GRAY_MASTIC_RESIN.get(), (Block)GarnishedBlocks.GRAY_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)LIGHT_GRAY_MASTIC_RESIN.get(), (Block)GarnishedBlocks.LIGHT_GRAY_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)WHITE_MASTIC_RESIN.get(), (Block)GarnishedBlocks.WHITE_ZULTANITE.get());
        Fluids.lavaInteraction(fluidState, (Fluid)BROWN_MASTIC_RESIN.get(), (Block)GarnishedBlocks.BROWN_ZULTANITE.get());
        return null;
    }

    public static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        public Vector3f fogColor;
        public Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        public SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        public int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        public Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        public float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    private static class NoColorFluidAttributes
    extends AllFluids.TintedFluidType {
        public NoColorFluidAttributes(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }
    }
}

