/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.math.Equation;

public class NbtEquations {
    private static final Logger LOGGER = LogManager.getLogger();

    public static CompoundTag solveNbtCompoundEquations(CompoundTag nbt, Map<String, Double> variableMap) {
        CompoundTag solved = new CompoundTag();
        for (String key : nbt.m_128431_()) {
            if (nbt.m_128435_(key) == 8 && key.startsWith("equation_")) {
                try {
                    double solution = Equation.parse(nbt.m_128461_(key)).apply(variableMap);
                    key = key.substring(9);
                    if (key.startsWith("int_")) {
                        key = key.substring(4);
                        solved.m_128405_(key, (int)solution);
                        continue;
                    }
                    if (key.startsWith("boolean_")) {
                        key = key.substring(8);
                        solved.m_128379_(key, Equation.toBoolean(solution));
                        continue;
                    }
                    if (key.startsWith("double_")) {
                        key = key.substring(7);
                        solved.m_128347_(key, solution);
                        continue;
                    }
                    solved.m_128347_(key, solution);
                }
                catch (Equation.EquationParseException e) {
                    LOGGER.error((Object)e);
                }
                continue;
            }
            if (nbt.m_128435_(key) == 10) {
                solved.m_128365_(key, (Tag)NbtEquations.solveNbtCompoundEquations(nbt.m_128469_(key), variableMap));
                continue;
            }
            if (nbt.m_128435_(key) == 9) {
                solved.m_128365_(key, (Tag)NbtEquations.solveListTagEquations((ListTag)nbt.m_128423_(key), variableMap));
                continue;
            }
            solved.m_128365_(key, nbt.m_128423_(key));
        }
        return solved;
    }

    public static ListTag solveListTagEquations(ListTag ListTag2, Map<String, Double> variableMap) {
        ListTag solved = new ListTag();
        for (Tag nbt : ListTag2) {
            if (nbt.m_7060_() == 9) {
                solved.add((Object)NbtEquations.solveListTagEquations((ListTag)nbt, variableMap));
                continue;
            }
            if (nbt.m_7060_() == 10) {
                solved.add((Object)NbtEquations.solveNbtCompoundEquations((CompoundTag)nbt, variableMap));
                continue;
            }
            solved.add((Object)nbt);
        }
        return solved;
    }
}

