/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.WaterLoggableBlockWithEntity;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class DimensionalPortalBlock
extends WaterLoggableBlockWithEntity
implements RiftProvider<EntranceRiftBlockEntity> {
    public static DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public DimensionalPortalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EntranceRiftBlockEntity getRift(Level world, BlockPos pos, BlockState state) {
        return (EntranceRiftBlockEntity)world.m_7702_(pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EntranceRiftBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.f_46443_) {
            return;
        }
        this.getRift(world, pos, state).teleport(entity);
        EntranceRiftBlockEntity rift = this.getRift(world, pos, state);
        world.m_46597_(pos, ((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_());
        ((DetachedRiftBlockEntity)world.m_7702_(pos)).setData(rift.getData());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isTall(BlockState cachedState) {
        return true;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        ((EntranceRiftBlockEntity)world.m_7702_(pos)).setPortalDestination((ServerLevel)world);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return Dummy.checkType(type, (BlockEntityType)ModBlockEntityTypes.ENTRANCE_RIFT.get(), DimensionalPortalBlock::portalTick);
    }

    private static void portalTick(Level world, BlockPos pos, BlockState state, EntranceRiftBlockEntity e) {
        e.tick(world, pos, state);
        if (world.m_5776_() || e.getDestination() != null) {
            return;
        }
        e.setPortalDestination((ServerLevel)world);
    }

    public static final class Dummy
    extends BaseEntityBlock {
        protected Dummy(BlockBehaviour.Properties settings) {
            super(settings);
        }

        @Nullable
        public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
            return Dummy.m_152132_(givenType, expectedType, ticker);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return null;
        }
    }
}

