/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.item.forge.RaycastHelperImpl;

public final class RaycastHelper {
    public static final int REACH_DISTANCE = 16;
    public static Predicate<BlockEntity> DETACH = blockEntity -> blockEntity instanceof DetachedRiftBlockEntity;
    public static Predicate<BlockEntity> RIFT = blockEntity -> blockEntity instanceof RiftBlockEntity;

    public static boolean hitsDetachedRift(HitResult hit, BlockGetter world) {
        return hit != null && hit.m_6662_() == HitResult.Type.BLOCK && world.m_7702_(((BlockHitResult)hit).m_82425_()) instanceof DetachedRiftBlockEntity;
    }

    public static boolean hitsRift(HitResult hit, BlockGetter world) {
        return hit != null && hit.m_6662_() == HitResult.Type.BLOCK && world.m_7702_(((BlockHitResult)hit).m_82425_()) instanceof RiftBlockEntity;
    }

    public static boolean hitsLivingEntity(HitResult hit) {
        return hit != null && hit.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)hit).m_82443_() instanceof LivingEntity;
    }

    public static HitResult raycast(Player entity, float tickDelta, Predicate<Entity> predicate) {
        return RaycastHelper.raycast(entity, 16.0, tickDelta, predicate);
    }

    public static HitResult raycast(Player entity, double maxDistance, float tickDelta, Predicate<Entity> predicate) {
        Vec3 vec3d = entity.m_20299_(tickDelta);
        Vec3 vec3d2 = entity.m_20252_(tickDelta);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * maxDistance, vec3d2.f_82480_ * maxDistance, vec3d2.f_82481_ * maxDistance);
        AABB box = entity.m_20191_().m_82369_(vec3d2.m_82490_(maxDistance)).m_82377_(1.0, 1.0, 1.0);
        return ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3d, (Vec3)vec3d3, (AABB)box, predicate, (double)maxDistance);
    }

    public static BlockHitResult findDetachRift(Entity entity, Predicate<BlockEntity> clazz) {
        Vec3 eye = entity.m_20299_(0.0f);
        Vec3 viewVec = entity.m_20252_(0.0f);
        Vec3 dest = eye.m_82520_(viewVec.f_82479_ * 16.0, viewVec.f_82480_ * 16.0, viewVec.f_82481_ * 16.0);
        return entity.m_9236_().m_45547_(new SignClipContext(eye, dest, entity, clazz));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double reach(Player player) {
        return RaycastHelperImpl.reach(player);
    }

    static class SignClipContext<T extends BlockEntity>
    extends ClipContext {
        private final Predicate<BlockEntity> predicate;

        public SignClipContext(Vec3 eye, Vec3 dest, Entity entity, Predicate<BlockEntity> predicate) {
            super(eye, dest, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity);
            this.predicate = predicate;
        }

        public VoxelShape m_45694_(BlockState pBlockState, BlockGetter pLevel, BlockPos pPos) {
            if (this.predicate.test(pLevel.m_7702_(pPos))) {
                return Shapes.m_83144_();
            }
            return super.m_45694_(pBlockState, pLevel, pPos);
        }
    }
}

