/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.dimdev.dimdoors.api.util.SchematicStructureTemplate;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StructureTemplateManager.class})
public abstract class StructureTemplateManagerMixin {
    private static final FileToIdConverter SCHEM_LISTER = new FileToIdConverter("structures", ".schem");
    @Shadow
    private ResourceManager f_230347_;
    @Shadow
    @Final
    private static Logger f_230340_;

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList$Builder;add(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;", ordinal=2, shift=At.Shift.AFTER, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addFabricTemplateProvider(ResourceManager resourceManager, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, HolderGetter<Block> blockLookup, CallbackInfo ci, ImmutableList.Builder<StructureTemplateManager.Source> builder) {
        builder.add((Object)new StructureTemplateManager.Source(this::loadSchemFromResource, this::listSchemResources));
    }

    private Optional<StructureTemplate> loadSchemFromResource(ResourceLocation id) {
        ResourceLocation resourceLocation = SCHEM_LISTER.m_245698_(id);
        return this.loadSchem(() -> this.f_230347_.m_215595_(resourceLocation), throwable -> f_230340_.error("Couldn't load structure {}", (Object)id, throwable));
    }

    private Stream<ResourceLocation> listSchemResources() {
        return SCHEM_LISTER.m_247457_(this.f_230347_).keySet().stream().map(arg_0 -> ((FileToIdConverter)SCHEM_LISTER).m_245273_(arg_0));
    }

    private Optional<StructureTemplate> loadSchem(StructureTemplateManager.InputStreamOpener inputStream, Consumer<Throwable> onError) {
        Optional<StructureTemplate> optional;
        InputStream is = null;
        try {
            is = inputStream.m_230439_();
            optional = Optional.of(this.readSchematic(is));
        }
        catch (Throwable e) {
            try {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        e.addSuppressed(throwable);
                    }
                }
                throw e;
            }
            catch (IOException ex) {
                onError.accept(ex);
                return Optional.empty();
            }
        }
        return optional;
    }

    private SchematicStructureTemplate readSchematic(InputStream is) throws IOException {
        CompoundTag compoundTag = NbtIo.m_128939_((InputStream)is);
        return new SchematicStructureTemplate(compoundTag);
    }
}

