/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.LazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class LazyPocketGenerator
extends PocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean currentlyGenerating = false;
    public static Queue<LevelChunk> generationQueue = new LinkedList<LevelChunk>();
    protected List<LazyModifier> lazyModifierList = new ArrayList<LazyModifier>();

    public void generateChunk(LazyGenerationPocket pocket, LevelChunk chunk) {
        this.lazyModifierList.forEach(modifier -> modifier.applyToChunk(pocket, (ChunkAccess)chunk));
    }

    public void attachToPocket(LazyGenerationPocket pocket) {
        if (this.modifierList.size() > 0) {
            throw new UnsupportedOperationException("Cannot attach LazyPocketGenerator that has not been cloned yet to pocket");
        }
        pocket.attachGenerator(this);
    }

    @Override
    public PocketGenerator fromNbt(CompoundTag nbt, ResourceManager manager) {
        ListTag modifiersNbt;
        super.fromNbt(nbt, manager);
        if (nbt.m_128441_("lazy_modifiers")) {
            modifiersNbt = nbt.m_128437_("lazy_modifiers", 10);
            for (int i = 0; i < modifiersNbt.size(); ++i) {
                this.lazyModifierList.add((LazyModifier)Modifier.deserialize(modifiersNbt.m_128728_(i), manager));
            }
        }
        if (nbt.m_128441_("lazy_modifier_references")) {
            modifiersNbt = nbt.m_128437_("lazy_modifier_references", 8);
            for (Tag nbtElement : modifiersNbt) {
                this.lazyModifierList.add((LazyModifier)Modifier.deserialize(nbtElement, manager));
            }
        }
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        if (this.lazyModifierList.size() > 0) {
            List<Tag> lazyModNbts = this.lazyModifierList.stream().map(lazyModifier -> lazyModifier.toNbt(new CompoundTag(), allowReference)).toList();
            ListTag lazyModifiersNbt = new ListTag();
            lazyModifiersNbt.addAll(lazyModNbts.stream().filter(CompoundTag.class::isInstance).toList());
            nbt.m_128365_("lazy_modifiers", (Tag)lazyModifiersNbt);
            ListTag lazyModifierReferences = new ListTag();
            lazyModifiersNbt.addAll(lazyModNbts.stream().filter(StringTag.class::isInstance).toList());
            nbt.m_128365_("lazy_modifier_references", (Tag)lazyModifierReferences);
        }
        return nbt;
    }

    @Override
    public RiftManager getRiftManager(Pocket pocket) {
        if (pocket instanceof LazyGenerationPocket) {
            return new RiftManager(pocket, true);
        }
        return new RiftManager(pocket, false);
    }

    public void attachLazyModifiers(Collection<LazyModifier> lazyModifiers) {
        this.lazyModifierList.addAll(lazyModifiers);
    }

    public LazyPocketGenerator cloneWithLazyModifiers(BlockPos originalOrigin) {
        LazyPocketGenerator clone = this.cloneWithEmptyModifiers(originalOrigin);
        clone.attachLazyModifiers(this.modifierList.stream().filter(LazyModifier.class::isInstance).map(LazyModifier.class::cast).collect(Collectors.toList()));
        return clone;
    }

    public LazyPocketGenerator cloneWithEmptyModifiers(BlockPos originalOrigin) {
        LazyPocketGenerator generator = this.getNewInstance();
        generator.setupLoot = this.setupLoot;
        return generator;
    }

    public void setSetupLoot(Boolean setupLoot) {
        this.setupLoot = setupLoot;
    }

    public abstract LazyPocketGenerator getNewInstance();

    public void setupChunk(Pocket pocket, ChunkAccess chunk, boolean setupLootTables) {
        MinecraftServer server = DimensionalDoors.getServer();
        chunk.m_5928_().stream().map(arg_0 -> ((ChunkAccess)chunk).m_7702_(arg_0)).forEach(blockEntity -> {
            if (setupLootTables && blockEntity instanceof Container) {
                Container inventory = (Container)blockEntity;
                server.m_6937_((Runnable)new TickTask(server.m_129921_(), () -> {
                    if (inventory.m_7983_() && (blockEntity instanceof ChestBlockEntity || blockEntity instanceof DispenserBlockEntity)) {
                        TemplateUtils.setupLootTable(DimensionalDoors.getWorld(pocket.getWorld()), blockEntity, inventory, LOGGER);
                    }
                }));
            }
        });
    }
}

