/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractLazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.util.schematic.SchematicBlockPalette;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class ShellModifier
extends AbstractLazyModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "shell";
    private final List<Layer> layers = new ArrayList<Layer>();
    private BoundingBox boxToDrawAround;

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        ListTag layersNbt = new ListTag();
        for (Layer layer : this.layers) {
            layersNbt.add((Object)layer.toNbt());
        }
        nbt.m_128365_("layers", (Tag)layersNbt);
        if (this.boxToDrawAround != null) {
            nbt.m_128365_("box_to_draw_around", (Tag)BlockBoxUtil.toNbt(this.boxToDrawAround));
        }
        return nbt;
    }

    @Override
    public void applyToChunk(LazyGenerationPocket pocket, ChunkAccess chunk) {
        int boxExpansion = 0;
        for (Layer layer : this.layers) {
            int thickness = layer.getThickness(pocket.toVariableMap(new HashMap<String, Double>()));
            BlockState blockState = layer.getBlockState();
            BoundingBox chunkBox = BlockBoxUtil.getBox(chunk);
            BoundingBox temp = BoundingBox.m_162375_((Vec3i)new Vec3i(this.boxToDrawAround.m_162399_() + 1 + boxExpansion, this.boxToDrawAround.m_162396_() - thickness - boxExpansion, this.boxToDrawAround.m_162398_() - thickness - boxExpansion), (Vec3i)new Vec3i(this.boxToDrawAround.m_162399_() + thickness + boxExpansion, this.boxToDrawAround.m_162400_() + thickness + boxExpansion, this.boxToDrawAround.m_162401_() + thickness + boxExpansion));
            if (temp.m_71049_(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                BlockPos.m_121919_((BoundingBox)temp).forEach(blockPos -> {
                    if (chunk.m_8055_(blockPos).m_60795_()) {
                        chunk.m_6978_(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = BoundingBox.m_162375_((Vec3i)new Vec3i(this.boxToDrawAround.m_162395_() - 1 - boxExpansion, this.boxToDrawAround.m_162396_() - thickness - boxExpansion, this.boxToDrawAround.m_162398_() - thickness - boxExpansion), (Vec3i)new Vec3i(this.boxToDrawAround.m_162395_() - thickness - boxExpansion, this.boxToDrawAround.m_162400_() + thickness + boxExpansion, this.boxToDrawAround.m_162401_() + thickness + boxExpansion))).m_71049_(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                BlockPos.m_121919_((BoundingBox)temp).forEach(blockPos -> {
                    if (chunk.m_8055_(blockPos).m_60795_()) {
                        chunk.m_6978_(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = BoundingBox.m_162375_((Vec3i)new Vec3i(this.boxToDrawAround.m_162395_() - boxExpansion, this.boxToDrawAround.m_162400_() + 1 + boxExpansion, this.boxToDrawAround.m_162398_() - thickness - boxExpansion), (Vec3i)new Vec3i(this.boxToDrawAround.m_162399_() + boxExpansion, this.boxToDrawAround.m_162400_() + thickness + boxExpansion, this.boxToDrawAround.m_162401_() + thickness + boxExpansion))).m_71049_(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                BlockPos.m_121919_((BoundingBox)temp).forEach(blockPos -> {
                    if (chunk.m_8055_(blockPos).m_60734_() instanceof AirBlock) {
                        chunk.m_6978_(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = BoundingBox.m_162375_((Vec3i)new Vec3i(this.boxToDrawAround.m_162395_() - boxExpansion, this.boxToDrawAround.m_162396_() - 1 - boxExpansion, this.boxToDrawAround.m_162398_() - thickness - boxExpansion), (Vec3i)new Vec3i(this.boxToDrawAround.m_162399_() + boxExpansion, this.boxToDrawAround.m_162396_() - thickness - boxExpansion, this.boxToDrawAround.m_162401_() + thickness + boxExpansion))).m_71049_(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                BlockPos.m_121919_((BoundingBox)temp).forEach(blockPos -> {
                    if (chunk.m_8055_(blockPos).m_60795_()) {
                        chunk.m_6978_(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = BoundingBox.m_162375_((Vec3i)new Vec3i(this.boxToDrawAround.m_162395_() - boxExpansion, this.boxToDrawAround.m_162396_() - boxExpansion, this.boxToDrawAround.m_162398_() - 1 - boxExpansion), (Vec3i)new Vec3i(this.boxToDrawAround.m_162399_() + boxExpansion, this.boxToDrawAround.m_162400_() + boxExpansion, this.boxToDrawAround.m_162398_() - thickness - boxExpansion))).m_71049_(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                BlockPos.m_121919_((BoundingBox)temp).forEach(blockPos -> {
                    if (chunk.m_8055_(blockPos).m_60795_()) {
                        chunk.m_6978_(blockPos, blockState, false);
                    }
                });
            }
            if ((temp = BoundingBox.m_162375_((Vec3i)new Vec3i(this.boxToDrawAround.m_162395_() - boxExpansion, this.boxToDrawAround.m_162396_() - boxExpansion, this.boxToDrawAround.m_162401_() + 1 + boxExpansion), (Vec3i)new Vec3i(this.boxToDrawAround.m_162399_() + boxExpansion, this.boxToDrawAround.m_162400_() + boxExpansion, this.boxToDrawAround.m_162401_() + thickness + boxExpansion))).m_71049_(chunkBox)) {
                temp = BlockBoxUtil.intersect(temp, chunkBox);
                BlockPos.m_121919_((BoundingBox)temp).forEach(blockPos -> {
                    if (chunk.m_8055_(blockPos).m_60795_()) {
                        chunk.m_6978_(blockPos, blockState, false);
                    }
                });
            }
            boxExpansion += thickness;
        }
    }

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        for (Tag layerNbt : nbt.m_128437_("layers", 10)) {
            CompoundTag nbtCompound = (CompoundTag)layerNbt;
            try {
                Layer layer = Layer.fromNbt(nbtCompound);
                this.layers.add(layer);
            }
            catch (CommandSyntaxException e) {
                LOGGER.error("could not parse Layer: " + String.valueOf(nbtCompound), (Throwable)e);
            }
        }
        if (nbt.m_128425_("box_to_draw_around", 11)) {
            int[] box = nbt.m_128465_("box_to_draw_around");
            this.boxToDrawAround = BoundingBox.m_162375_((Vec3i)new Vec3i(box[0], box[1], box[2]), (Vec3i)new Vec3i(box[3], box[4], box[5]));
        }
        return this;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.SHELL_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Pocket pocket = manager.getPocket();
        if (pocket instanceof LazyGenerationPocket) {
            Map<String, Double> variableMap = pocket.toVariableMap(new HashMap<String, Double>());
            BoundingBox pocketBox = pocket.getBox();
            this.boxToDrawAround = BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162395_(), pocketBox.m_162396_(), pocketBox.m_162398_()), (Vec3i)new Vec3i(pocketBox.m_162399_(), pocketBox.m_162400_(), pocketBox.m_162401_()));
            this.layers.forEach(layer -> pocket.expand(layer.getThickness(variableMap)));
        } else {
            this.layers.forEach(layer -> this.drawLayer((Layer)layer, manager.getPocket(), parameters.world()));
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        for (Layer layer : this.layers) {
            int thickness = layer.getThickness(variableMap);
            builder.expandExpected(new Vec3i(2 * thickness, 2 * thickness, 2 * thickness));
            builder.offsetOrigin(new Vec3i(thickness, thickness, thickness));
        }
    }

    private void drawLayer(Layer layer, Pocket pocket, ServerLevel world) {
        int thickness = layer.getThickness(pocket.toVariableMap(new HashMap<String, Double>()));
        BlockState blockState = layer.getBlockState();
        BoundingBox pocketBox = pocket.getBox();
        BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162399_() + 1, pocketBox.m_162396_() - thickness, pocketBox.m_162398_() - thickness), (Vec3i)new Vec3i(pocketBox.m_162399_() + thickness, pocketBox.m_162400_() + thickness, pocketBox.m_162401_() + thickness))).forEach(blockPos -> world.m_46597_(blockPos, blockState));
        BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162395_() - 1, pocketBox.m_162396_() - thickness, pocketBox.m_162398_() - thickness), (Vec3i)new Vec3i(pocketBox.m_162395_() - thickness, pocketBox.m_162400_() + thickness, pocketBox.m_162401_() + thickness))).forEach(blockPos -> world.m_46597_(blockPos, blockState));
        BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162395_(), pocketBox.m_162400_() + 1, pocketBox.m_162398_() - thickness), (Vec3i)new Vec3i(pocketBox.m_162399_(), pocketBox.m_162400_() + thickness, pocketBox.m_162401_() + thickness))).forEach(blockPos -> world.m_46597_(blockPos, blockState));
        BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162395_(), pocketBox.m_162396_() - 1, pocketBox.m_162398_() - thickness), (Vec3i)new Vec3i(pocketBox.m_162399_(), pocketBox.m_162396_() - thickness, pocketBox.m_162401_() + thickness))).forEach(blockPos -> world.m_46597_(blockPos, blockState));
        BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162395_(), pocketBox.m_162396_(), pocketBox.m_162398_() - 1), (Vec3i)new Vec3i(pocketBox.m_162399_(), pocketBox.m_162400_(), pocketBox.m_162398_() - thickness))).forEach(blockPos -> world.m_46597_(blockPos, blockState));
        BlockPos.m_121919_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(pocketBox.m_162395_(), pocketBox.m_162396_(), pocketBox.m_162401_() + 1), (Vec3i)new Vec3i(pocketBox.m_162399_(), pocketBox.m_162400_(), pocketBox.m_162401_() + thickness))).forEach(blockPos -> world.m_46597_(blockPos, blockState));
        pocket.expand(thickness);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("layers", this.layers).toString();
    }

    public static class Layer {
        private final String blockStateString;
        private final String thickness;
        private Equation thicknessEquation;
        private final BlockState blockState;

        public Layer(String blockStateString, String thickness) {
            this.blockStateString = blockStateString;
            this.thickness = thickness;
            try {
                this.thicknessEquation = Equation.parse(thickness);
            }
            catch (Equation.EquationParseException e) {
                LOGGER.error("Could not parse layer thickness equation. Defaulting to 1");
                this.thicknessEquation = Equation.newEquation(variableMap -> 1.0, stringBuilder -> stringBuilder.append(thickness));
            }
            this.blockState = (BlockState)SchematicBlockPalette.Entry.to(blockStateString).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public int getThickness(Map<String, Double> variableMap) {
            return (int)this.thicknessEquation.apply(variableMap);
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("block_state", this.blockStateString);
            nbt.m_128359_("thickness", this.thickness);
            return nbt;
        }

        public static Layer fromNbt(CompoundTag nbt) throws CommandSyntaxException {
            return new Layer(nbt.m_128461_("block_state"), nbt.m_128461_("thickness"));
        }
    }
}

