/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModStructureProccessors;
import org.jetbrains.annotations.Nullable;

public class DestinationDataModifier
extends StructureProcessor {
    private final Map<Integer, CompoundTag> destinations;
    public static final Codec<DestinationDataModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, String::valueOf), (Codec)CompoundTag.f_128325_).fieldOf("destinations").forGetter(DestinationDataModifier::destinations)).apply((Applicative)instance, DestinationDataModifier::new));

    private DestinationDataModifier(Map<Integer, CompoundTag> destinations) {
        this.destinations = destinations;
    }

    public static DestinationDataModifier of(Map<Integer, VirtualTarget> destinations) {
        return new DestinationDataModifier(destinations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> VirtualTarget.toNbt((VirtualTarget)entry.getValue()))));
    }

    public static DestinationDataModifier of(int id, VirtualTarget data) {
        return DestinationDataModifier.of(Map.of(id, data));
    }

    public static DestinationDataModifier of(VirtualTarget data) {
        return DestinationDataModifier.of(0, data);
    }

    public Map<Integer, CompoundTag> destinations() {
        return this.destinations;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        CompoundTag data = this.apply(relativeBlockInfo.f_74677_());
        return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.f_74675_(), relativeBlockInfo.f_74676_(), data);
    }

    public CompoundTag apply(@Nullable CompoundTag tag) {
        CompoundTag data;
        int id;
        if (tag != null && tag.m_128441_("data") && (id = this.getMarkerId(data = tag.m_128469_("data"))) >= 0 && this.destinations.containsKey(id)) {
            CompoundTag nbt = this.destinations.get(id);
            data.m_128365_("destination", (Tag)nbt);
        }
        return tag;
    }

    public StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)ModStructureProccessors.DESTINATION_DATA.get();
    }

    private int getMarkerId(CompoundTag data) {
        CompoundTag destination = data.m_128469_("destination");
        if (destination.m_128461_("type").equals("dimdoors:id_marker")) {
            return destination.m_128451_("id");
        }
        return -1;
    }
}

