/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.common.ComfortsEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ComfortsCommonEventsListener {
    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        if (!ComfortsEvents.canSetSpawn(evt.getEntity(), evt.getNewSpawn())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(SleepingTimeCheckEvent evt) {
        evt.getSleepingLocation().ifPresent(pos -> {
            ComfortsEvents.Result result = ComfortsEvents.checkTime(evt.getEntity().m_9236_(), pos);
            switch (result) {
                case ALLOW: {
                    evt.setResult(Event.Result.ALLOW);
                    break;
                }
                case DENY: {
                    evt.setResult(Event.Result.DENY);
                }
            }
        });
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            long time;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            long newTime = evt.getNewTime();
            if (newTime != (time = ComfortsEvents.getWakeTime(serverLevel, serverLevel.m_46468_(), newTime))) {
                evt.setTimeAddition(time);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        ComfortsEvents.onWakeUp(evt.getEntity());
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent evt) {
        Player.BedSleepingProblem result = ComfortsEvents.onSleep(evt.getEntity());
        if (result != null) {
            evt.setResult(result);
        }
    }
}

