/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.surface;

import com.mojang.datafixers.util.Pair;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.AddSurfaceRuleModifier;
import dev.worldgen.lithostitched.worldgen.surface.LithostitchedSurfaceRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SurfaceRuleManager {
    public static void applySurfaceRules(MinecraftServer server) {
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        Set surfaceRules = registryAccess.m_175515_(LithostitchedRegistryKeys.WORLDGEN_MODIFIER).m_6579_().stream().filter(entry -> entry.getValue() instanceof AddSurfaceRuleModifier).collect(Collectors.toSet());
        if (surfaceRules.isEmpty()) {
            return;
        }
        HashMap assignedSurfaceRules = new HashMap();
        for (Map.Entry assignedSurfaceRule : surfaceRules) {
            AddSurfaceRuleModifier slice = (AddSurfaceRuleModifier)assignedSurfaceRule.getValue();
            slice.levels().forEach(levelStemResourceKey -> assignedSurfaceRules.computeIfAbsent(levelStemResourceKey.m_135782_(), __ -> new ArrayList()).add(Pair.of((Object)((ResourceKey)assignedSurfaceRule.getKey()).m_135782_(), (Object)slice)));
        }
        Registry dimensions = registryAccess.m_175515_(Registries.f_256862_);
        for (Map.Entry entry2 : dimensions.m_6579_()) {
            ChunkGenerator chunkGenerator;
            ResourceLocation location = ((ResourceKey)entry2.getKey()).m_135782_();
            ArrayList surfaceRulesForKey = (ArrayList)assignedSurfaceRules.get(location);
            if (surfaceRulesForKey == null || !((chunkGenerator = ((LevelStem)entry2.getValue()).f_63976_()) instanceof NoiseBasedChunkGenerator)) continue;
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)((NoiseBasedChunkGenerator)chunkGenerator).m_224341_().m_203334_();
            SurfaceRules.RuleSource oldRules = settings.f_188871_();
            ((NoiseBasedChunkGenerator)chunkGenerator).f_64318_ = Holder.m_205709_((Object)new NoiseGeneratorSettings(settings.f_64439_(), settings.f_64440_(), settings.f_64441_(), settings.f_209353_(), SurfaceRuleManager.buildModdedSurfaceRules(surfaceRulesForKey, oldRules), settings.f_224370_(), settings.f_64444_(), settings.f_64445_(), settings.m_158567_(), settings.m_209369_(), settings.f_209354_()));
            LithostitchedCommon.debug("Applied {} surface rule additions for '{}' dimension", surfaceRulesForKey.size(), location);
        }
    }

    private static SurfaceRules.RuleSource buildModdedSurfaceRules(ArrayList<Pair<ResourceLocation, AddSurfaceRuleModifier>> moddedSourceList, SurfaceRules.RuleSource originalSource) {
        ArrayList<SurfaceRules.RuleSource> newRuleSourceList = new ArrayList<SurfaceRules.RuleSource>();
        moddedSourceList.forEach((Consumer<Pair<ResourceLocation, AddSurfaceRuleModifier>>)((Consumer<Pair>)pair -> newRuleSourceList.add(((AddSurfaceRuleModifier)pair.getSecond()).surfaceRule())));
        newRuleSourceList.add(originalSource);
        if (originalSource instanceof LithostitchedSurfaceRules.TransientMergedRuleSource) {
            ((LithostitchedSurfaceRules.TransientMergedRuleSource)originalSource).sequence().addAll(newRuleSourceList);
            return originalSource;
        }
        return new LithostitchedSurfaceRules.TransientMergedRuleSource(newRuleSourceList, originalSource);
    }
}

