/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.v2.emissive.forge;

import com.blackgear.platform.client.v2.emissive.Emissiveness;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeEmissiveLayerBakedModel
implements BakedModel {
    private static final ConcurrentHashMap<BlockState, RenderType> DEFAULT_RENDER_TYPE_CACHE = new ConcurrentHashMap();
    private static final int EMISSIVE_BRIGHTNESS = 0xF000F0;
    private static final int VERTEX_SIZE = 8;
    private static final int VERTICES_PER_QUAD = 4;
    private static final int U_OFFSET = 4;
    private static final int V_OFFSET = 5;
    private static final int BRIGHTNESS_OFFSET = 6;
    private final BakedModel wrapped;

    public ForgeEmissiveLayerBakedModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType renderType) {
        List originalQuads = this.wrapped.getQuads(state, side, random, data, renderType);
        if (originalQuads.isEmpty()) {
            return originalQuads;
        }
        List<BakedQuad> emissiveQuads = this.createEmissiveQuads(originalQuads, state, renderType);
        return emissiveQuads.isEmpty() ? originalQuads : ImmutableList.builder().addAll((Iterable)originalQuads).addAll(emissiveQuads).build();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        List<BakedQuad> emissiveQuads;
        List originalQuads = this.wrapped.m_213637_(state, direction, random);
        if (originalQuads.isEmpty()) {
            return originalQuads;
        }
        List<BakedQuad> list = emissiveQuads = state == null ? this.createItemEmissiveQuads(originalQuads) : this.createEmissiveQuads(originalQuads, state, null);
        if (!emissiveQuads.isEmpty()) {
            return ImmutableList.builder().addAll((Iterable)originalQuads).addAll(emissiveQuads).build();
        }
        return originalQuads;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ChunkRenderTypeSet originalTypes = this.wrapped.getRenderTypes(state, rand, data);
        if (!Emissiveness.hasEmissiveSprite(this.wrapped)) {
            return originalTypes;
        }
        HashSet<RenderType> renderTypes = new HashSet<RenderType>();
        originalTypes.forEach(renderTypes::add);
        if (originalTypes.contains(RenderType.m_110451_())) {
            renderTypes.add(RenderType.m_110457_());
        }
        return ChunkRenderTypeSet.of(renderTypes);
    }

    public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
        List originalPasses = this.wrapped.getRenderPasses(stack, fabulous);
        if (originalPasses.size() == 1 && originalPasses.get(0) == this.wrapped) {
            return Collections.singletonList(this);
        }
        return originalPasses.stream().map(model -> {
            if (model instanceof ForgeEmissiveLayerBakedModel || !Emissiveness.hasEmissiveSprite(model)) {
                return model;
            }
            return new ForgeEmissiveLayerBakedModel((BakedModel)model);
        }).collect(Collectors.toList());
    }

    @NotNull
    public List<RenderType> getRenderTypes(@NotNull ItemStack stack, boolean fabulous) {
        List originalTypes = this.wrapped.getRenderTypes(stack, fabulous);
        if (Emissiveness.hasEmissiveSprite(this.wrapped)) {
            HashSet<RenderType> types = new HashSet<RenderType>(originalTypes);
            if (!(types.contains(RenderType.m_110463_()) || types.contains(RenderType.m_110457_()) || types.contains(RenderType.m_110466_()))) {
                types.add(RenderType.m_110463_());
            }
            return new ArrayList<RenderType>(types);
        }
        return originalTypes;
    }

    private List<BakedQuad> createEmissiveQuads(List<BakedQuad> originalQuads, @Nullable BlockState state, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> emissiveQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : originalQuads) {
            TextureAtlasSprite sprite = quad.m_173410_();
            TextureAtlasSprite emissiveSprite = Emissiveness.INSTANCE.getEmissiveSprite(sprite);
            if (emissiveSprite == null) continue;
            RenderType emissiveRenderType = this.getEmissiveRenderType(state, renderType);
            if (renderType != null && renderType != emissiveRenderType) continue;
            emissiveQuads.add(this.createEmissiveQuad(quad, emissiveSprite));
        }
        return emissiveQuads;
    }

    private List<BakedQuad> createItemEmissiveQuads(List<BakedQuad> originalQuads) {
        if (originalQuads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> emissiveQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : originalQuads) {
            TextureAtlasSprite sprite = quad.m_173410_();
            TextureAtlasSprite emissiveSprite = Emissiveness.INSTANCE.getEmissiveSprite(sprite);
            if (emissiveSprite == null) continue;
            emissiveQuads.add(this.createEmissiveQuad(quad, emissiveSprite));
        }
        return emissiveQuads;
    }

    private RenderType getEmissiveRenderType(@Nullable BlockState state, @Nullable RenderType origin) {
        if (origin == RenderType.m_110451_()) {
            return RenderType.m_110457_();
        }
        if (origin == RenderType.m_110463_() || origin == RenderType.m_110457_() || origin == RenderType.m_110466_()) {
            return origin;
        }
        if (state != null) {
            RenderType defaultType = DEFAULT_RENDER_TYPE_CACHE.computeIfAbsent(state, ItemBlockRenderTypes::m_109282_);
            return defaultType == RenderType.m_110451_() ? RenderType.m_110457_() : RenderType.m_110463_();
        }
        return RenderType.m_110463_();
    }

    private BakedQuad createEmissiveQuad(BakedQuad originalQuad, TextureAtlasSprite emissiveSprite) {
        int[] emissiveVertices = this.interpolateUVAndBrightness(originalQuad.m_111303_(), originalQuad.m_173410_(), emissiveSprite);
        return new BakedQuad(emissiveVertices, originalQuad.m_111305_(), originalQuad.m_111306_(), emissiveSprite, originalQuad.m_111307_());
    }

    private int[] interpolateUVAndBrightness(int[] originalVertices, TextureAtlasSprite baseSprite, TextureAtlasSprite emissiveSprite) {
        int[] newVertices = (int[])originalVertices.clone();
        float baseU0 = baseSprite.m_118409_();
        float baseV0 = baseSprite.m_118411_();
        float baseURange = baseSprite.m_118410_() - baseU0;
        float baseVRange = baseSprite.m_118412_() - baseV0;
        float emissiveU0 = emissiveSprite.m_118409_();
        float emissiveV0 = emissiveSprite.m_118411_();
        float emissiveURange = emissiveSprite.m_118410_() - emissiveU0;
        float emissiveVRange = emissiveSprite.m_118412_() - emissiveV0;
        for (int vertex = 0; vertex < 4; ++vertex) {
            int vertexStart = vertex * 8;
            float originalU = Float.intBitsToFloat(newVertices[vertexStart + 4]);
            float originalV = Float.intBitsToFloat(newVertices[vertexStart + 5]);
            float normalizedU = baseURange > 0.0f ? (originalU - baseU0) / baseURange : 0.0f;
            float normalizedV = baseVRange > 0.0f ? (originalV - baseV0) / baseVRange : 0.0f;
            float emissiveU = emissiveU0 + normalizedU * emissiveURange;
            float emissiveV = emissiveV0 + normalizedV * emissiveVRange;
            newVertices[vertexStart + 4] = Float.floatToRawIntBits(emissiveU);
            newVertices[vertexStart + 5] = Float.floatToRawIntBits(emissiveV);
            newVertices[vertexStart + 6] = 0xF000F0;
        }
        return newVertices;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return this.wrapped.getModelData(level, pos, state, modelData);
    }

    public boolean m_7541_() {
        return this.wrapped.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrapped.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrapped.m_7547_();
    }

    public boolean m_7521_() {
        return this.wrapped.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.wrapped.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    public ItemOverrides m_7343_() {
        return this.wrapped.m_7343_();
    }

    public ItemTransforms m_7442_() {
        return this.wrapped.m_7442_();
    }
}

