/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import com.kyanite.deeperdarker.world.otherside.OthersideTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class OthersidePortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public OthersidePortalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AXIS});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_(AXIS) == Direction.Axis.X) {
            return X_AXIS_AABB;
        }
        return Z_AXIS_AABB;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        Direction.Axis facingAxis = pDirection.m_122434_();
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        boolean flag = axis != facingAxis && facingAxis.m_122479_();
        return !flag && !pNeighborState.m_60713_((Block)this) && !new OthersidePortalShape(pLevel, pPos, axis).isComplete() ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((double)pRandom.m_188501_() < 7.0E-4) {
            pLevel.m_7785_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (SoundEvent)DDSounds.PORTAL_GROAN.get(), SoundSource.BLOCKS, 0.2f, pRandom.m_188501_() * 0.2f + 0.9f, false);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pEntity.m_20159_() && !pEntity.m_20160_() && pEntity.m_6072_()) {
            if (pEntity.m_20092_()) {
                pEntity.m_20091_();
            } else {
                MinecraftServer server;
                if (!pLevel.f_46443_ && !pPos.equals((Object)pEntity.f_19819_)) {
                    pEntity.f_19819_ = pPos.m_7949_();
                }
                if ((server = pLevel.m_7654_()) == null) {
                    return;
                }
                if (pLevel.m_46472_() != OthersideDimension.OTHERSIDE_LEVEL && pLevel.m_46472_() != Level.f_46428_) {
                    return;
                }
                ResourceKey<Level> destination = pLevel.m_46472_() == OthersideDimension.OTHERSIDE_LEVEL ? Level.f_46428_ : OthersideDimension.OTHERSIDE_LEVEL;
                ServerLevel destWorld = server.m_129880_(destination);
                if (destWorld != null && !pEntity.m_20159_()) {
                    pLevel.m_46473_().m_6180_("portal");
                    pEntity.m_20091_();
                    pEntity.changeDimension(destWorld, (ITeleporter)new OthersideTeleporter(destWorld));
                    pLevel.m_46473_().m_7238_();
                }
            }
        }
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return switch (direction) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    public boolean spawnPortal(LevelAccessor worldIn, BlockPos pos) {
        OthersidePortalShape portal = this.isPortal(worldIn, pos);
        if (portal != null && !OthersidePortalBlock.trySpawningPortal(worldIn, pos, portal)) {
            portal.createPortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean trySpawningPortal(LevelAccessor world, BlockPos pos, OthersidePortalShape portal) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.m_8055_(pos), portal));
    }

    public OthersidePortalShape isPortal(LevelAccessor level, BlockPos pos) {
        OthersidePortalShape portalX = new OthersidePortalShape(level, pos, Direction.Axis.X);
        if (portalX.isValid() && portalX.numPortalBlocks == 0) {
            return portalX;
        }
        OthersidePortalShape portalZ = new OthersidePortalShape(level, pos, Direction.Axis.Z);
        return portalZ.isValid() && portalZ.numPortalBlocks == 0 ? portalZ : null;
    }

    public static class OthersidePortalShape {
        public static final int MIN_WIDTH = 2;
        public static final int MIN_HEIGHT = 2;
        public static final int MAX_WIDTH = 21;
        public static final int MAX_HEIGHT = 21;
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private BlockPos bottomLeft;
        private int numPortalBlocks;
        private int height;
        private final int width;

        public OthersidePortalShape(LevelAccessor level, BlockPos bottomLeft, Direction.Axis axis) {
            this.level = level;
            this.axis = axis;
            this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(bottomLeft);
            if (this.bottomLeft == null) {
                this.bottomLeft = bottomLeft;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculateWidth();
                if (this.width > 0) {
                    this.height = this.calculateHeight();
                }
            }
        }

        private BlockPos calculateBottomLeft(BlockPos pos) {
            int height = Math.max(this.level.m_141937_(), pos.m_123342_() - 21);
            while (pos.m_123342_() > height && OthersidePortalShape.isEmpty(this.level.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            Direction direction = this.rightDir.m_122424_();
            int j = this.getFrameWidth(pos, direction) - 1;
            return j < 0 ? null : pos.m_5484_(direction, j);
        }

        private int calculateHeight() {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            int i = this.getFrameHeight(blockPos);
            return i >= 2 && i <= 21 && this.hasTopFrame(blockPos, i) ? i : 0;
        }

        private int calculateWidth() {
            int i = this.getFrameWidth(this.bottomLeft, this.rightDir);
            return i >= 2 && i <= 21 ? i : 0;
        }

        private int getFrameHeight(BlockPos.MutableBlockPos pos) {
            for (int i = 0; i < 21; ++i) {
                pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
                if (!this.level.m_8055_((BlockPos)pos).m_60713_(Blocks.f_220863_)) {
                    return i;
                }
                pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
                if (!this.level.m_8055_((BlockPos)pos).m_60713_(Blocks.f_220863_)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                    BlockState blockState = this.level.m_8055_((BlockPos)pos);
                    if (!OthersidePortalShape.isEmpty(blockState)) {
                        return i;
                    }
                    if (!blockState.m_60713_((Block)DDBlocks.OTHERSIDE_PORTAL.get())) continue;
                    ++this.numPortalBlocks;
                }
            }
            return 21;
        }

        private int getFrameWidth(BlockPos pos, Direction direction) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int i = 0; i <= 21; ++i) {
                blockPos.m_122190_((Vec3i)pos).m_122175_(direction, i);
                BlockState blockState = this.level.m_8055_((BlockPos)blockPos);
                if (!OthersidePortalShape.isEmpty(blockState)) {
                    if (!blockState.m_60713_(Blocks.f_220863_)) break;
                    return i;
                }
                BlockState blockStateDown = this.level.m_8055_((BlockPos)blockPos.m_122173_(Direction.DOWN));
                if (!blockStateDown.m_60713_(Blocks.f_220863_)) break;
            }
            return 0;
        }

        private boolean hasTopFrame(BlockPos.MutableBlockPos pos, int n) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos blockPos = pos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, n).m_122175_(this.rightDir, i);
                if (this.level.m_8055_((BlockPos)blockPos).m_60713_(Blocks.f_220863_)) continue;
                return false;
            }
            return true;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)((OthersidePortalBlock)((Object)DDBlocks.OTHERSIDE_PORTAL.get())).m_49966_().m_61124_(AXIS, (Comparable)this.axis);
            BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(blockPos -> this.level.m_7731_(blockPos, blockstate, 18));
        }

        public boolean isComplete() {
            return this.isValid() && this.numPortalBlocks == this.width * this.height;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 2 && this.height <= 21;
        }

        private static boolean isEmpty(BlockState state) {
            return state.m_60795_() || state.m_60713_((Block)DDBlocks.OTHERSIDE_PORTAL.get());
        }
    }

    public static class PortalSpawnEvent
    extends BlockEvent {
        private final OthersidePortalShape size;

        public PortalSpawnEvent(LevelAccessor level, BlockPos pos, BlockState state, OthersidePortalShape size) {
            super(level, pos, state);
            this.size = size;
        }

        public OthersidePortalShape getSize() {
            return this.size;
        }
    }
}

