/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.util;

import com.kyanite.deeperdarker.content.DDItems;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum DDArmorMaterials implements ArmorMaterial
{
    RESONARIUM("resonarium", 30, new int[]{2, 6, 7, 3}, 10, SoundEvents.f_11677_, 1.0f, 0.0f, (ItemLike)DDItems.RESONARIUM.get()),
    WARDEN("warden", 40, new int[]{4, 7, 9, 4}, 18, SoundEvents.f_11679_, 4.0f, 0.1f, (ItemLike)DDItems.REINFORCED_ECHO_SHARD.get());

    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> defensePoints;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Ingredient repairIngredient;
    private static final EnumMap<ArmorItem.Type, Integer> DURABILITY_FOR_TYPE;

    private DDArmorMaterials(String name, int durability, int[] defensePoints, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, ItemLike repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.defensePoints = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, defensePoints[0]);
            map.put(ArmorItem.Type.LEGGINGS, defensePoints[1]);
            map.put(ArmorItem.Type.CHESTPLATE, defensePoints[2]);
            map.put(ArmorItem.Type.HELMET, defensePoints[3]);
        });
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairIngredient});
    }

    public int m_266425_(ArmorItem.Type type) {
        return DURABILITY_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.defensePoints.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient;
    }

    public String m_6082_() {
        return "deeperdarker:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        DURABILITY_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

