/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.renderer.html;

import dev.dediamondpro.resourcify.libs.commonmark.internal.util.Escaping;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class HtmlWriter {
    private static final Map<String, String> NO_ATTRIBUTES = Collections.emptyMap();
    private final Appendable buffer;
    private char lastChar = '\u0000';

    public HtmlWriter(Appendable out) {
        if (out == null) {
            throw new NullPointerException("out must not be null");
        }
        this.buffer = out;
    }

    public void raw(String s) {
        this.append(s);
    }

    public void text(String text) {
        this.append(Escaping.escapeHtml(text));
    }

    public void tag(String name) {
        this.tag(name, NO_ATTRIBUTES);
    }

    public void tag(String name, Map<String, String> attrs) {
        this.tag(name, attrs, false);
    }

    public void tag(String name, Map<String, String> attrs, boolean voidElement) {
        this.append("<");
        this.append(name);
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, String> attrib : attrs.entrySet()) {
                this.append(" ");
                this.append(Escaping.escapeHtml(attrib.getKey()));
                this.append("=\"");
                this.append(Escaping.escapeHtml(attrib.getValue()));
                this.append("\"");
            }
        }
        if (voidElement) {
            this.append(" /");
        }
        this.append(">");
    }

    public void line() {
        if (this.lastChar != '\u0000' && this.lastChar != '\n') {
            this.append("\n");
        }
    }

    protected void append(String s) {
        try {
            this.buffer.append(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int length = s.length();
        if (length != 0) {
            this.lastChar = s.charAt(length - 1);
        }
    }
}

