/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.StyleEntry;
import java.awt.Color;
import java.util.HashMap;

public class LayoutStyle {
    private final HashMap<StyleEntry<?>, Object> styles;
    public static final StyleEntry<Alignment> ALIGNMENT = new StyleEntry<Alignment>(Alignment.class, Alignment.LEFT);
    public static final StyleEntry<Float> FONT_SIZE = new StyleEntry<Float>(Float.class);
    public static final StyleEntry<Color> TEXT_COLOR = new StyleEntry<Color>(Color.class);
    public static final StyleEntry<Boolean> BOLD = new StyleEntry<Boolean>(Boolean.class, false);
    public static final StyleEntry<Boolean> ITALIC = new StyleEntry<Boolean>(Boolean.class, false);
    public static final StyleEntry<Boolean> UNDERLINED = new StyleEntry<Boolean>(Boolean.class, false);
    public static final StyleEntry<Boolean> STRIKETHROUGH = new StyleEntry<Boolean>(Boolean.class, false);
    public static final StyleEntry<Boolean> PART_OF_LINK = new StyleEntry<Boolean>(Boolean.class, false);
    public static final StyleEntry<Boolean> PRE_FORMATTED = new StyleEntry<Boolean>(Boolean.class, false);
    public static final StyleEntry<Boolean> PART_OF_CODE_BLOCK = new StyleEntry<Boolean>(Boolean.class, false);

    public LayoutStyle(HashMap<StyleEntry<?>, Object> styles) {
        this.styles = styles;
    }

    public LayoutStyle(Style style) {
        this(new HashMap());
        this.put(FONT_SIZE, Float.valueOf(style.getTextStyle().getDefaultFontSize()));
        this.put(TEXT_COLOR, style.getTextStyle().getDefaultTextColor());
    }

    public LayoutStyle clone() {
        return new LayoutStyle((HashMap)this.styles.clone());
    }

    public <T> void put(StyleEntry<T> styleEntry, T value) {
        this.styles.put(styleEntry, value);
    }

    public <T> void set(StyleEntry<T> styleEntry, T value) {
        this.styles.put(styleEntry, value);
    }

    public <T> void remove(StyleEntry<T> styleEntry) {
        this.styles.remove(styleEntry);
    }

    public <T> boolean has(StyleEntry<T> styleEntry) {
        return this.styles.containsKey(styleEntry);
    }

    public <T> boolean hasOrDefault(StyleEntry<T> styleEntry) {
        return this.has(styleEntry) || styleEntry.getDefaultValue() != null;
    }

    public <T> T get(StyleEntry<T> styleEntry) {
        return this.getOrDefault(styleEntry, styleEntry.getDefaultValue());
    }

    public <T> T getOrDefault(StyleEntry<T> styleEntry, T defaultValue) {
        return styleEntry.getStyleClass().cast(this.styles.getOrDefault(styleEntry, defaultValue));
    }

    @Deprecated
    public Alignment getAlignment() {
        return this.get(ALIGNMENT);
    }

    @Deprecated
    public void setAlignment(Alignment alignment) {
        this.set(ALIGNMENT, alignment);
    }

    @Deprecated
    public float getFontSize() {
        return this.get(FONT_SIZE).floatValue();
    }

    @Deprecated
    public void setFontSize(float fontSize) {
        this.set(FONT_SIZE, Float.valueOf(fontSize));
    }

    @Deprecated
    public Color getTextColor() {
        return this.get(TEXT_COLOR);
    }

    @Deprecated
    public void setTextColor(Color textColor) {
        this.set(TEXT_COLOR, textColor);
    }

    @Deprecated
    public boolean isBold() {
        return this.get(BOLD);
    }

    @Deprecated
    public void setBold(boolean bold) {
        this.set(BOLD, bold);
    }

    @Deprecated
    public boolean isItalic() {
        return this.get(ITALIC);
    }

    @Deprecated
    public void setItalic(boolean italic) {
        this.set(ITALIC, italic);
    }

    @Deprecated
    public boolean isUnderlined() {
        return this.get(UNDERLINED);
    }

    @Deprecated
    public void setUnderlined(boolean underlined) {
        this.set(UNDERLINED, underlined);
    }

    @Deprecated
    public boolean isStrikethrough() {
        return this.get(STRIKETHROUGH);
    }

    @Deprecated
    public void setStrikethrough(boolean strikethrough) {
        this.set(STRIKETHROUGH, strikethrough);
    }

    @Deprecated
    public boolean isPartOfLink() {
        return this.get(PART_OF_LINK);
    }

    @Deprecated
    public void setPartOfLink(boolean partOfLink) {
        this.set(PART_OF_LINK, partOfLink);
    }

    @Deprecated
    public boolean isPreFormatted() {
        return this.get(PRE_FORMATTED);
    }

    @Deprecated
    public void setPreFormatted(boolean preFormatted) {
        this.set(PRE_FORMATTED, preFormatted);
    }

    @Deprecated
    public boolean isPartOfCodeBlock() {
        return this.get(PART_OF_CODE_BLOCK);
    }

    @Deprecated
    public void setPartOfCodeBlock(boolean partOfCodeBlock) {
        this.set(PART_OF_CODE_BLOCK, partOfCodeBlock);
    }

    public static enum Alignment {
        CENTER,
        LEFT,
        RIGHT;

    }
}

