/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.yungnickyoung.minecraft.yungscavebiomes.module.CriteriaModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public class PricklyPeachCactusBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty FRUIT = BlockStateProperties.f_155977_;
    public static final IntegerProperty AGE = BlockStateProperties.f_61411_;
    protected static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)8.0, (double)11.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)11.0);
    private static final float AGE_CHANCE = 0.5f;
    private static final float BERRY_CHANCE = 0.1f;
    private static final int MAX_AGE = 25;

    public PricklyPeachCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (((Boolean)blockState.m_61143_((Property)FRUIT)).booleanValue()) {
            PricklyPeachCactusBlock.popFruit(level, blockPos, new ItemStack((ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get(), 1));
            float volume = Mth.m_216283_((RandomSource)level.f_46441_, (float)0.8f, (float)1.2f);
            level.m_5594_(null, blockPos, SoundEvents.f_144088_, SoundSource.BLOCKS, 1.0f, volume);
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)FRUIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        ItemStack itemInHand = player.m_21120_(interactionHand);
        if (itemInHand.m_41619_()) {
            player.m_6469_(level.m_269111_().m_269325_(), 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaModule.INTERACT_EMPTY_PRICKLY_CACTUS.trigger(serverPlayer);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (PricklyPeachCactusBlock.isMaxAge(blockState) || PricklyPeachCactusBlock.hasFruit(blockState)) {
            return;
        }
        if (random.m_188500_() < 0.5) {
            int newAge = (Integer)blockState.m_61143_((Property)AGE) + 1;
            BlockState newBlockState = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge));
            if (random.m_188500_() < (double)0.1f || newAge == 25) {
                newBlockState = (BlockState)newBlockState.m_61124_((Property)FRUIT, (Comparable)Boolean.valueOf(true));
            }
            serverLevel.m_46597_(blockPos, newBlockState);
        }
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        super.m_213646_(blockState, serverLevel, blockPos, itemStack, bl);
        if (blockState.m_61138_((Property)FRUIT) && ((Boolean)blockState.m_61143_((Property)FRUIT)).booleanValue()) {
            Block.m_49840_((Level)serverLevel, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get(), 1));
        }
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return blockState.m_61138_((Property)FRUIT) && (Boolean)blockState.m_61143_((Property)FRUIT) == false;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource random, BlockPos blockPos, BlockState blockState) {
        serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)FRUIT, (Comparable)Boolean.valueOf(true)), 2);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return COLLISION_SHAPE;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return OUTLINE_SHAPE;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState blockStateBelow = levelReader.m_8055_(blockPos.m_7495_());
        return blockStateBelow.m_204336_(BlockTags.f_13029_);
    }

    public BlockState m_7417_(BlockState currState, Direction neighborDirection, BlockState neighborBlockState, LevelAccessor levelAccessor, BlockPos currPos, BlockPos neighborPos) {
        if (!currState.m_60710_((LevelReader)levelAccessor, currPos)) {
            levelAccessor.m_186460_(currPos, (Block)this, 1);
        }
        return super.m_7417_(currState, neighborDirection, neighborBlockState, levelAccessor, currPos, neighborPos);
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity.m_6095_() == EntityTypeModule.SAND_SNAPPER.get()) {
            return;
        }
        entity.m_6469_(level.m_269111_().m_269325_(), 1.0f);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, FRUIT});
    }

    private static boolean isMaxAge(BlockState blockState) {
        return blockState.m_61138_((Property)AGE) && (Integer)blockState.m_61143_((Property)AGE) == 25;
    }

    private static boolean hasFruit(BlockState blockState) {
        return blockState.m_61138_((Property)FRUIT) && (Boolean)blockState.m_61143_((Property)FRUIT) != false;
    }

    private static void popFruit(Level level, BlockPos $$1, ItemStack itemStack) {
        if (!level.f_46443_ && !itemStack.m_41619_() && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            double x = (double)$$1.m_123341_() + 0.5;
            double y = (double)$$1.m_123342_() + 0.5 - (double)(EntityType.f_20461_.m_20679_() / 2.0f);
            double z = (double)$$1.m_123343_() + 0.5;
            double xOffset = Mth.m_216263_((RandomSource)level.f_46441_, (double)0.2, (double)0.25);
            double yOffset = 0.25;
            double zOffset = Mth.m_216263_((RandomSource)level.f_46441_, (double)0.2, (double)0.25);
            double dx = Mth.m_216263_((RandomSource)level.f_46441_, (double)0.075, (double)0.1);
            double dy = 0.2;
            double dz = Mth.m_216263_((RandomSource)level.f_46441_, (double)0.075, (double)0.1);
            if (level.f_46441_.m_188499_()) {
                xOffset *= -1.0;
                dx *= -1.0;
            }
            if (level.f_46441_.m_188499_()) {
                zOffset *= -1.0;
                dz *= -1.0;
            }
            ItemEntity itemEntity = new ItemEntity(level, x += xOffset, y += yOffset, z += zOffset, itemStack, dx, dy, dz);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }
}

