/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterBlock;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

public class BlockModuleForge {
    public static final List<ExtraBlockData> EXTRA_BLOCKS = new ArrayList<ExtraBlockData>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BlockModuleForge::registerBlocks);
    }

    private static void registerBlocks(RegisterEvent event) {
        event.register(Registries.f_256747_, helper -> AutoRegistrationManager.BLOCKS.stream().filter(data -> !data.processed()).forEach(data -> BlockModuleForge.registerBlock(data, (RegisterEvent.RegisterHelper<Block>)helper)));
    }

    private static void registerBlock(AutoRegisterField data, RegisterEvent.RegisterHelper<Block> helper) {
        ResourceLocation name;
        AutoRegisterBlock autoRegisterBlock = (AutoRegisterBlock)data.object();
        Block block = (Block)autoRegisterBlock.get();
        helper.register(data.name(), (Object)block);
        String namespace = data.name().m_135827_();
        String path = data.name().m_135815_();
        if (autoRegisterBlock.hasStairs()) {
            StairBlock stairBlock = new StairBlock(() -> ((Block)block).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_stairs");
            helper.register(name, (Object)stairBlock);
            autoRegisterBlock.setStairs((Block)stairBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)stairBlock, autoRegisterBlock.getItemProperties(), name));
            }
        }
        if (autoRegisterBlock.hasSlab()) {
            SlabBlock slabBlock = new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_slab");
            helper.register(name, (Object)slabBlock);
            autoRegisterBlock.setSlab((Block)slabBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)slabBlock, autoRegisterBlock.getItemProperties(), name));
            }
        }
        if (autoRegisterBlock.hasFence()) {
            FenceBlock fenceBlock = new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_fence");
            helper.register(name, (Object)fenceBlock);
            autoRegisterBlock.setFence((Block)fenceBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)fenceBlock, autoRegisterBlock.getItemProperties(), name));
            }
        }
        if (autoRegisterBlock.hasFenceGate()) {
            FenceGateBlock fenceGateBlock = new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block), autoRegisterBlock.getFenceGateWoodType());
            name = new ResourceLocation(namespace, path + "_fence_gate");
            helper.register(name, (Object)fenceGateBlock);
            autoRegisterBlock.setFenceGate((Block)fenceGateBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)fenceGateBlock, autoRegisterBlock.getItemProperties(), name));
            }
        }
        if (autoRegisterBlock.hasWall()) {
            WallBlock wallBlock = new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block));
            name = new ResourceLocation(namespace, path + "_wall");
            helper.register(name, (Object)wallBlock);
            autoRegisterBlock.setWall((Block)wallBlock);
            if (autoRegisterBlock.hasItemProperties()) {
                EXTRA_BLOCKS.add(new ExtraBlockData((Block)wallBlock, autoRegisterBlock.getItemProperties(), name));
            }
        }
        data.markProcessed();
    }

    public record ExtraBlockData(Block block, Supplier<Item.Properties> itemProperties, ResourceLocation blockRegisteredName) {
    }
}

