/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.InventoryTooltip;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkClientCompat;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.integration.ShulkerBoxTooltipCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class SackItem
extends BlockItem {
    public SackItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        int inc;
        float amount;
        ServerPlayer player;
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!CommonConfigs.Functional.SACK_PENALTY.get().booleanValue()) {
            return;
        }
        if (worldIn.m_46467_() % 27L == 0L && entityIn instanceof ServerPlayer && !(player = (ServerPlayer)entityIn).m_7500_() && !entityIn.m_5833_() && stack.m_41737_("BlockEntityTag") != null && (amount = ItemsUtil.getEncumbermentFromInventory(stack, player)) > (float)(inc = CommonConfigs.Functional.SACK_INCREMENT.get().intValue())) {
            player.m_7292_(new MobEffectInstance(ModRegistry.OVERENCUMBERED.get(), 200, ((int)amount - 1) / inc - 1, false, false, true));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag;
        boolean sbtTooltip;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        boolean quarkTooltip = CompatHandler.QUARK && QuarkClientCompat.canRenderQuarkTooltip();
        boolean bl = sbtTooltip = CompatHandler.SHULKER_BOX_TOOLTIP && ShulkerBoxTooltipCompat.hasPreviewProvider(stack);
        if (!quarkTooltip && !sbtTooltip && (tag = stack.m_41737_("BlockEntityTag")) != null) {
            ItemsUtil.addShulkerLikeTooltips(tag, tooltip);
        }
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_142023_(ItemEntity pItemEntity) {
        CompoundTag compoundtag = pItemEntity.m_32055_().m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128469_("BlockEntityTag").m_128437_("Items", 10);
            ItemUtils.m_150952_((ItemEntity)pItemEntity, listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_));
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        if (!CompatHandler.QUARK || !QuarkCompat.isShulkerDropInOn()) {
            return false;
        }
        return ItemsUtil.tryInteractingWithContainerItem(stack, incoming, slot, action, player, true);
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (!CompatHandler.QUARK || !QuarkCompat.isShulkerDropInOn()) {
            return false;
        }
        return ItemsUtil.tryInteractingWithContainerItem(stack, slot.m_7993_(), slot, action, player, false);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        CompoundTag cmp;
        boolean sbtTooltip;
        boolean quarkTooltip = CompatHandler.QUARK && QuarkClientCompat.canRenderQuarkTooltip();
        boolean bl = sbtTooltip = CompatHandler.SHULKER_BOX_TOOLTIP && ShulkerBoxTooltipCompat.hasPreviewProvider(pStack);
        if (quarkTooltip && !sbtTooltip && (cmp = pStack.m_41737_("BlockEntityTag")) != null && !cmp.m_128441_("LootTable")) {
            return Optional.of(new InventoryTooltip(cmp, (Item)this, CommonConfigs.Functional.SACK_SLOTS.get()));
        }
        return Optional.empty();
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static float getEncumber(ItemStack slotItem) {
        if (slotItem.m_41720_() instanceof SackItem) {
            ListTag l;
            CompoundTag bet;
            CompoundTag tag = slotItem.m_41783_();
            if (tag != null && !(bet = tag.m_128469_("BlockEntityTag")).m_128456_() && !(l = bet.m_128437_("Items", 10)).isEmpty()) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (slotItem.m_204117_(ModTags.OVERENCUMBERING)) {
            if (slotItem.m_41782_()) {
                return 1.0f;
            }
            return (float)slotItem.m_41613_() / (float)slotItem.m_41741_();
        }
        return 0.0f;
    }
}

