/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.forge;

import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuiverItemImpl {
    @Nullable
    public static QuiverItem.Data getQuiverData(ItemStack stack) {
        return CapabilityHandler.get((ICapabilityProvider)stack, CapabilityHandler.QUIVER_ITEM_HANDLER);
    }

    public static QuiverItem.Data getQuiverDataOrThrow(ItemStack stack) {
        return CapabilityHandler.getOrThrow((ICapabilityProvider)stack, CapabilityHandler.QUIVER_ITEM_HANDLER);
    }

    public static class Cap
    extends ItemStackHandler
    implements ICapabilitySerializable<CompoundTag>,
    QuiverItem.Data {
        private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(() -> this);
        private final LazyOptional<Cap> lazyOptional2 = LazyOptional.of(() -> this);
        private int selectedSlot = 0;

        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            LazyOptional v = ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.lazyOptional);
            if (v.isPresent()) {
                return v;
            }
            v = CapabilityHandler.QUIVER_ITEM_HANDLER.orEmpty(cap, this.lazyOptional2);
            return v;
        }

        public CompoundTag serializeNBT() {
            CompoundTag c = super.serializeNBT();
            c.m_128405_("SelectedSlot", this.selectedSlot);
            return c;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.selectedSlot = nbt.m_128445_("SelectedSlot");
        }

        public Cap(int maxSlots) {
            super(maxSlots);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.canAcceptItem(stack);
        }

        @Override
        public List<ItemStack> getContentView() {
            return this.stacks;
        }

        @Override
        public int getSelectedSlot() {
            return this.selectedSlot;
        }

        @Override
        public void setSelectedSlot(int selectedSlot) {
            if (!((ItemStack)this.stacks.get(selectedSlot)).m_41619_()) {
                this.selectedSlot = selectedSlot;
            }
        }

        @Override
        public boolean cycle(int slotsMoved) {
            ItemStack stack;
            int originalSlot = this.selectedSlot;
            int maxSlots = this.stacks.size();
            this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved %= maxSlots))) % maxSlots;
            for (int i = 0; i < maxSlots && (stack = this.getStackInSlot(this.selectedSlot)).m_41619_(); ++i) {
                this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved >= 0 ? 1 : -1))) % maxSlots;
            }
            return originalSlot != this.selectedSlot;
        }

        @Override
        public ItemStack tryAdding(ItemStack toInsert, boolean onlyOnExisting) {
            if (!toInsert.m_41619_() && toInsert.m_41720_().m_142095_()) {
                if (onlyOnExisting) {
                    int finalCount = toInsert.m_41613_();
                    for (int i = 0; i < this.getSlots() && finalCount > 0; ++i) {
                        ItemStack s = this.getStackInSlot(i);
                        if (!ItemStack.m_150942_((ItemStack)s, (ItemStack)toInsert)) continue;
                        int newCount = Math.min(s.m_41741_(), s.m_41613_() + finalCount);
                        int increment = newCount - s.m_41613_();
                        finalCount -= increment;
                        s.m_41769_(increment);
                        this.onContentsChanged(i);
                    }
                    toInsert.m_41764_(finalCount);
                    return toInsert;
                }
                return ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)toInsert, (boolean)false);
            }
            return toInsert;
        }

        @Override
        public Optional<ItemStack> removeOneStack() {
            int i = 0;
            for (ItemStack s : this.getContentView()) {
                if (!s.m_41619_()) {
                    ItemStack extracted = this.extractItem(i, s.m_41613_(), false);
                    this.updateSelectedIfNeeded();
                    return Optional.of(extracted);
                }
                ++i;
            }
            return Optional.empty();
        }

        @Override
        public void consumeSelected() {
            ItemStack s = this.getSelected();
            s.m_41774_(1);
            if (s.m_41619_()) {
                this.stacks.set(this.selectedSlot, (Object)ItemStack.f_41583_);
            }
            this.updateSelectedIfNeeded();
        }
    }
}

