/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions;

import com.github.eterdelta.crittersandcompanions.client.model.BubbleModel;
import com.github.eterdelta.crittersandcompanions.client.model.GrapplingHookModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.DragonflyModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.DumboOctopusModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.JumpingSpiderModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.KoiFishModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.LeafInsectModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.RedPandaModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.SeaBunnyModel;
import com.github.eterdelta.crittersandcompanions.client.model.geo.ShimaEnagaModel;
import com.github.eterdelta.crittersandcompanions.client.renderer.BubbleLayer;
import com.github.eterdelta.crittersandcompanions.client.renderer.GrapplingHookRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.FerretRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.OtterRenderer;
import com.github.eterdelta.crittersandcompanions.mixin.ItemPropertiesAccessor;
import com.github.eterdelta.crittersandcompanions.platform.event.RegisterEntityRenderers;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class CrittersAndCompanionsClient {
    private static final ItemPropertyFunction BUCKET_VARIANT = (stack, clientLevel, entity, seed) -> {
        String tagKey = "BucketVariant";
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(tagKey)) {
            return stack.m_41783_().m_128451_(tagKey);
        }
        return 0.0f;
    };

    private static void registerProperty(Item item, ResourceLocation id, ItemPropertyFunction function) {
        ItemPropertiesAccessor.getPROPERTIES().computeIfAbsent(item, $ -> new HashMap()).put(id, function);
    }

    public static void init() {
        CrittersAndCompanionsClient.registerProperty((Item)CACItems.DUMBO_OCTOPUS_BUCKET.get(), new ResourceLocation("variant"), BUCKET_VARIANT);
        CrittersAndCompanionsClient.registerProperty((Item)CACItems.SEA_BUNNY_BUCKET.get(), new ResourceLocation("variant"), BUCKET_VARIANT);
    }

    public static void registerEntityRenderers(RegisterEntityRenderers event) {
        event.accept((EntityType)CACEntities.OTTER.get(), OtterRenderer::new);
        event.accept((EntityType)CACEntities.JUMPING_SPIDER.get(), context -> new GeoEntityRenderer(context, (GeoModel)new JumpingSpiderModel()));
        event.accept((EntityType)CACEntities.KOI_FISH.get(), context -> new GeoEntityRenderer(context, (GeoModel)new KoiFishModel()));
        event.accept((EntityType)CACEntities.DRAGONFLY.get(), context -> new GeoEntityRenderer(context, (GeoModel)new DragonflyModel()));
        event.accept((EntityType)CACEntities.SEA_BUNNY.get(), context -> new GeoEntityRenderer(context, (GeoModel)new SeaBunnyModel()));
        event.accept((EntityType)CACEntities.SHIMA_ENAGA.get(), context -> new GeoEntityRenderer(context, (GeoModel)new ShimaEnagaModel()));
        event.accept((EntityType)CACEntities.FERRET.get(), FerretRenderer::new);
        event.accept((EntityType)CACEntities.GRAPPLING_HOOK.get(), GrapplingHookRenderer::new);
        event.accept((EntityType)CACEntities.DUMBO_OCTOPUS.get(), context -> new GeoEntityRenderer(context, (GeoModel)new DumboOctopusModel()));
        event.accept((EntityType)CACEntities.LEAF_INSECT.get(), context -> new GeoEntityRenderer(context, (GeoModel)new LeafInsectModel()));
        event.accept((EntityType)CACEntities.RED_PANDA.get(), context -> new GeoEntityRenderer(context, (GeoModel)new RedPandaModel()));
    }

    public static void registerEntityLayers(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> event) {
        event.accept(BubbleLayer.LAYER_LOCATION, BubbleModel::createLayer);
        event.accept(GrapplingHookRenderer.LAYER_LOCATION, GrapplingHookModel::createLayer);
    }
}

