/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.api.CACColors;
import com.github.eterdelta.crittersandcompanions.entity.FerretEntity;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class FerretOverlayerLayer
extends GeoRenderLayer<FerretEntity> {
    private static final Map<DyeColor, ResourceLocation> TEXTURES = FerretOverlayerLayer.createTextures(false);
    private static final Map<DyeColor, ResourceLocation> BABY_TEXTURES = FerretOverlayerLayer.createTextures(true);

    private static Map<DyeColor, ResourceLocation> createTextures(boolean baby) {
        String base = baby ? "baby_ferret" : "ferret";
        ImmutableMap.Builder map = new ImmutableMap.Builder();
        CACColors.supported().forEach(dye -> {
            ResourceLocation id = CrittersAndCompanions.createId("textures/entity/%s_tamed_overlay_%s.png".formatted(base, dye.m_7912_()));
            map.put(dye, (Object)id);
        });
        return map.build();
    }

    public FerretOverlayerLayer(GeoRenderer<FerretEntity> renderer) {
        super(renderer);
    }

    @Nullable
    protected ResourceLocation getTextureResource(FerretEntity animatable) {
        DyeColor color = animatable.getCollarColor();
        if (color == null) {
            return null;
        }
        Map<DyeColor, ResourceLocation> map = animatable.m_6162_() ? BABY_TEXTURES : TEXTURES;
        return map.get(color);
    }

    public void render(PoseStack poseStack, FerretEntity animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        ResourceLocation texture = this.getTextureResource(animatable);
        if (texture == null) {
            return;
        }
        renderType = RenderType.m_110452_((ResourceLocation)texture);
        buffer = bufferSource.m_6299_(renderType);
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, buffer, partialTick, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

