/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import java.util.Optional;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapplingHookEntity
extends Projectile {
    protected static final EntityDataAccessor<ItemStack> OWNER_STACK = SynchedEntityData.m_135353_(GrapplingHookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected boolean isStick;
    protected double stickLength;
    private boolean addedToWorld;

    public GrapplingHookEntity(EntityType<? extends GrapplingHookEntity> entityType, Level level) {
        super(entityType, level);
    }

    public GrapplingHookEntity(Player owner, ItemStack ownerStack, Level level) {
        this((EntityType<? extends GrapplingHookEntity>)((EntityType)CACEntities.GRAPPLING_HOOK.get()), level);
        this.m_7678_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_(), owner.m_6080_(), owner.m_146909_());
        this.m_5602_((Entity)owner);
        this.setOwnerStack(ownerStack);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.addedToWorld) {
            this.updateOwnerState();
            this.addedToWorld = true;
        }
        double offsetLengthSqr = this.m_20280_(this.m_19749_());
        Double maxDistance = (Double)Services.CONFIGS.common().grapplingHookMaxDistance.get();
        double maxDistanceSqr = maxDistance * maxDistance;
        if (!(this.m_9236_().m_5776_() || this.isFocused() && !(offsetLengthSqr > maxDistanceSqr))) {
            this.m_146870_();
            return;
        }
        AABB collidableBox = this.m_20191_().m_82400_(0.25);
        Iterable collisions = this.m_9236_().m_186434_((Entity)this, collidableBox);
        boolean willStick = false;
        for (VoxelShape shape : collisions) {
            if (shape.m_83281_() || !shape.m_83215_().m_82381_(collidableBox)) continue;
            willStick = true;
            break;
        }
        if (willStick && !this.isStick) {
            this.stickLength = offsetLengthSqr;
            this.m_216990_(SoundEvents.f_12388_);
        }
        this.isStick = willStick;
        if (this.isStick && this.m_19749_() != null) {
            if (offsetLengthSqr > this.stickLength) {
                Vec3 direction = this.m_20182_().m_82546_(this.m_19749_().m_20182_()).m_82541_();
                Double maxSpeed = (Double)Services.CONFIGS.common().grapplingHookMaxSpeed.get();
                double scale = Math.min(maxSpeed, 0.01 * Math.sqrt(offsetLengthSqr));
                if (scale >= 0.0) {
                    this.m_19749_().m_20256_(this.m_19749_().m_20184_().m_82549_(direction.m_82490_(scale)));
                    this.m_19749_().f_19864_ = true;
                }
            }
            this.m_20334_(0.0, 0.0, 0.0);
        } else {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        this.updateOwnerState();
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public void pull() {
        if (this.m_19749_() != null) {
            if (this.isStick) {
                double pullSpeed = (Double)Services.CONFIGS.common().grapplingHookSpeed.get() / 4.0;
                Double maxSpeed = (Double)Services.CONFIGS.common().grapplingHookMaxSpeed.get();
                Vec3 direction = this.m_20182_().m_82546_(this.m_19749_().m_20182_()).m_82541_();
                float distance = this.m_20270_(this.m_19749_());
                this.m_19749_().m_20256_(direction.m_82490_(Math.min(maxSpeed, pullSpeed * (double)distance)));
            }
            this.m_146870_();
        }
    }

    public void updateOwnerState() {
        Entity entity;
        if (!this.m_9236_().m_5776_() && this.m_19749_() != null && (entity = this.m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            entity = this.m_19749_();
            if (entity instanceof IGrapplingState) {
                IGrapplingState grapplingState = (IGrapplingState)entity;
                grapplingState.setHook(this.m_6084_() ? this : null);
                CACPacketHandler.GRAPPLING_STATE.sendToTracking((Entity)player, new ClientboundGrapplingStatePacket(this.m_6084_() ? Optional.of(this.m_19879_()) : Optional.empty(), player.m_19879_()));
            }
        }
    }

    public boolean isFocused() {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return ItemStack.m_150942_((ItemStack)player.m_21205_(), (ItemStack)this.getOwnerStack()) || ItemStack.m_150942_((ItemStack)player.m_21206_(), (ItemStack)this.getOwnerStack());
        }
        return false;
    }

    public ItemStack getOwnerStack() {
        return (ItemStack)this.f_19804_.m_135370_(OWNER_STACK);
    }

    public void setOwnerStack(ItemStack stack) {
        this.f_19804_.m_135381_(OWNER_STACK, (Object)stack);
    }
}

