/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.mixin;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.mixin.EntityAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    public LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(at={@At(value="TAIL")}, method={"render*"})
    private void onRender(T entity, float p_115456_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int p_115460_, CallbackInfo callback) {
        ISilkLeashState leashState = (ISilkLeashState)entity;
        Set<LivingEntity> leashedByEntities = leashState.getLeashedByEntities();
        for (LivingEntity leashedBy : leashedByEntities) {
            this.renderSilkLeash(entity, partialTicks, poseStack, bufferSource, leashedBy);
        }
    }

    @Unique
    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174315_, int p_174316_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_, float gradient) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.m_14179_((float)f, (float)p_174313_, (float)1.0f);
        int j = (int)Mth.m_14179_((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.m_109885_((int)i, (int)j);
        float f1 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.75f * f1 * gradient;
        float g = 0.72f * f1 * gradient;
        float b = 0.8f * f1 * gradient;
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        vertexConsumer.m_252986_(matrix4f, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).m_85950_(r, g, b, 1.0f).m_85969_(k).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f5 + p_174319_, f6 + 0.025f - p_174318_, f7 - p_174320_).m_85950_(r, g, b, 1.0f).m_85969_(k).m_5752_();
    }

    @Unique
    private <E extends Entity> void renderSilkLeash(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, E leashedToEntity) {
        poseStack.m_85836_();
        Vec3 vec3 = leashedToEntity.m_7398_(partialTicks);
        double d0 = (double)(Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = ((EntityAccessor)entity).invokeGetLeashOffset();
        double d1 = Math.cos(d0) * vec31.f_82481_ + Math.sin(d0) * vec31.f_82479_;
        double d2 = Math.sin(d0) * vec31.f_82481_ - Math.cos(d0) * vec31.f_82479_;
        double d3 = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entity).f_19854_, (double)entity.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entity).f_19855_, (double)entity.m_20186_()) + vec31.f_82480_;
        double d5 = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)entity).f_19856_, (double)entity.m_20189_()) + d2;
        poseStack.m_85837_(d1, vec31.f_82480_, d2);
        float f = (float)(vec3.f_82479_ - d3);
        float f1 = (float)(vec3.f_82480_ - d4);
        float f2 = (float)(vec3.f_82481_ - d5);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float f4 = (float)(Mth.m_14193_((double)(f * f + f2 * f2)) * (double)0.025f / 2.0);
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = BlockPos.m_274446_((Position)entity.m_20299_(partialTicks));
        BlockPos blockpos1 = BlockPos.m_274446_((Position)leashedToEntity.m_20299_(partialTicks));
        int i = this.m_6086_((Entity)entity, blockpos);
        int k = entity.m_9236_().m_45517_(LightLayer.SKY, blockpos);
        int l = entity.m_9236_().m_45517_(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 24; ++i1) {
            LivingEntityRendererMixin.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, k, l, 0.025f, f5, f6, i1, false, 0.25f + 0.75f * ((float)i1 / 24.0f));
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            LivingEntityRendererMixin.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, k, l, 0.0f, f5, f6, j1, true, 0.25f + 0.75f * ((float)j1 / 24.0f));
        }
        poseStack.m_85849_();
    }
}

