/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record BlueprintCauldronInteraction(ResourceLocation name, Map<Item, CauldronInteraction> map) {
    private static final Set<BlueprintCauldronInteraction> CAULDRON_INTERACTIONS = new ObjectArraySet();
    public static final BlueprintCauldronInteraction EMPTY = BlueprintCauldronInteraction.register(new ResourceLocation("empty"), CauldronInteraction.f_175606_);
    public static final BlueprintCauldronInteraction WATER = BlueprintCauldronInteraction.register(new ResourceLocation("water"), CauldronInteraction.f_175607_);
    public static final BlueprintCauldronInteraction LAVA = BlueprintCauldronInteraction.register(new ResourceLocation("lava"), CauldronInteraction.f_175608_);
    public static final BlueprintCauldronInteraction POWDER_SNOW = BlueprintCauldronInteraction.register(new ResourceLocation("powder_snow"), CauldronInteraction.f_175609_);

    public static BlueprintCauldronInteraction create(ResourceLocation name, Map<Item, CauldronInteraction> map) {
        return new BlueprintCauldronInteraction(name, map);
    }

    public static synchronized BlueprintCauldronInteraction register(BlueprintCauldronInteraction map) {
        CAULDRON_INTERACTIONS.add(map);
        return map;
    }

    public static BlueprintCauldronInteraction register(ResourceLocation name, Map<Item, CauldronInteraction> map) {
        return BlueprintCauldronInteraction.register(BlueprintCauldronInteraction.create(name, map));
    }

    public static void addMoreDefaultInteractions(Item item, CauldronInteraction interaction) {
        BlueprintCauldronInteraction.values().forEach(blueprintInteraction -> blueprintInteraction.map.put(item, interaction));
    }

    public static ImmutableList<BlueprintCauldronInteraction> values() {
        return ImmutableList.copyOf(CAULDRON_INTERACTIONS);
    }

    @Nullable
    public static BlueprintCauldronInteraction getTypeFromLocation(ResourceLocation name) {
        for (BlueprintCauldronInteraction interaction : BlueprintCauldronInteraction.values()) {
            if (!interaction.name().equals((Object)name)) continue;
            return interaction;
        }
        return null;
    }
}

