/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.player005.recipe_modification.api.ModificationSet;
import net.player005.recipe_modification.api.Platform;
import net.player005.recipe_modification.api.RecipeFilter;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.api.RecipeModifier;
import net.player005.recipe_modification.api.RecipeModifierHolder;
import net.player005.recipe_modification.api.ResultItemModifier;
import net.player005.recipe_modification.impl.mixin.RecipeManagerAccessor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecipeModification {
    public static final String modID = "recipe_modification";
    private static final Logger logger = LoggerFactory.getLogger(RecipeModification.class);
    private static Platform platform;
    private static final NonNullList<Consumer<RecipeManager>> recipeManagerCallbacks;
    private static final NonNullList<ResourceLocation> toRemove;
    private static final NonNullList<RecipeModifierHolder> modifiers;
    private static @UnknownNullability ImmutableList<RecipeModifierHolder> modifiersFromDatapack;
    public static final List<ResultItemModifier> resultModifiers;
    private static final Map<Recipe<?>, ItemStack> resultItemOverrides;
    private static @UnknownNullability ImmutableMultimap<Item, Recipe<?>> recipesByResult;
    private static @UnknownNullability RecipeManager recipeManager;

    public static void onRecipeInit(Consumer<RecipeManager> consumer) {
        recipeManagerCallbacks.add(consumer);
    }

    public static CompletableFuture<Void> forAllRecipesAsync(Consumer<Recipe<?>> recipeConsumer) {
        return CompletableFuture.runAsync(() -> recipeManager.m_44051_().forEach(recipeConsumer));
    }

    public static void registerGlobalResultModifier(ResultItemModifier modifier) {
        resultModifiers.add(modifier);
    }

    public static void modifyResultItemSimple(Recipe<?> recipe, Consumer<ItemStack> modifier) {
        ItemStack result = recipe.m_8043_(RecipeModification.getRegistryAccess());
        modifier.accept(result);
        if (recipe.m_8043_(RecipeModification.getRegistryAccess()) == result) {
            return;
        }
        RecipeModification.registerGlobalResultModifier((recipe1, result1, recipeInput) -> {
            if (recipe1 == recipe) {
                modifier.accept(result1);
            }
            return result1;
        });
    }

    public static void replaceResultItem(Recipe<?> recipe, ItemStack newResult) {
        resultItemOverrides.put(recipe, newResult);
    }

    public static void removeRecipe(ResourceLocation id) {
        toRemove.add((Object)id);
    }

    public static void registerModifier(RecipeModifierHolder recipeModifier) {
        modifiers.add((Object)recipeModifier);
    }

    public static void registerModifier(ResourceLocation id, RecipeFilter filter, ModificationSet modifications) {
        RecipeModification.registerModifier(new RecipeModifierHolder(id, filter, modifications));
    }

    public static void registerModifier(ResourceLocation id, RecipeFilter filter, RecipeModifier ... modifications) {
        RecipeModification.registerModifier(new RecipeModifierHolder(id, filter, modifications));
    }

    public static Recipe<?> getByID(ResourceLocation id) {
        RecipeModification.checkInitialised("get recipe by ID");
        return RecipeModification.getPlatform().getRecipeByID(recipeManager, id);
    }

    @ApiStatus.Internal
    public static void initPlatform(Platform platform) {
        RecipeModification.platform = platform;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static @UnknownNullability RecipeManager getRecipeManager() {
        return recipeManager;
    }

    public static RegistryAccess getRegistryAccess() {
        return RecipeModification.getPlatform().getRegistryAccess();
    }

    public static ImmutableMultimap<Item, Recipe<?>> getRecipesByResult() {
        RecipeModification.checkInitialised("get recipes by result map");
        return recipesByResult;
    }

    public static ImmutableCollection<Recipe<?>> getRecipesByResult(Item resultItem) {
        RecipeModification.checkInitialised("get recipe by result");
        return recipesByResult.get((Object)resultItem);
    }

    public static List<RecipeModifierHolder> getAllModifiers() {
        ArrayList<RecipeModifierHolder> fullList = new ArrayList<RecipeModifierHolder>(modifiers.size() + modifiersFromDatapack.size());
        fullList.addAll((Collection<RecipeModifierHolder>)modifiers);
        fullList.addAll((Collection<RecipeModifierHolder>)modifiersFromDatapack);
        return fullList;
    }

    public static ItemStack tryGetResult(Recipe<?> recipe, RegistryAccess registryAccess) {
        try {
            return recipe.m_8043_(registryAccess);
        }
        catch (Exception exception) {
            logger.warn("Failed to get result for recipe {}", (Object)recipe.m_6423_());
            logger.debug("Exception querying result:", (Throwable)exception);
            return ItemStack.f_41583_;
        }
    }

    public static boolean isInitialised() {
        return recipeManager != null;
    }

    private static void checkInitialised(String action) {
        if (!RecipeModification.isInitialised()) {
            throw new IllegalStateException("Can't " + action + " before recipes are initialised.Maybe you need to use RecipeModification#onRecipeInit() ?");
        }
    }

    @ApiStatus.Internal
    public static ItemStack getRecipeResult(Recipe<?> recipe, ItemStack currentResult, @Nullable Container recipeInput) {
        currentResult = resultItemOverrides.getOrDefault(recipe, currentResult).m_41777_();
        for (ResultItemModifier modifier : resultModifiers) {
            currentResult = modifier.getResultItem(recipe, currentResult, recipeInput);
        }
        return currentResult;
    }

    @ApiStatus.Internal
    public static void onRecipeManagerLoad(RecipeManager recipeManager) {
        RecipeModification.recipeManager = recipeManager;
        if (modifiersFromDatapack == null) {
            throw new IllegalStateException("Error loading Recipe Modification: Recipes were loaded before recipe modifiers were parsed");
        }
        RecipeModification.applyModifications();
    }

    @ApiStatus.Internal
    public static void updateJsonRecipeModifiers(ImmutableList<RecipeModifierHolder> modifiers) {
        modifiersFromDatapack = modifiers;
    }

    @ApiStatus.Internal
    private static void applyModifications() {
        Stopwatch timer = Stopwatch.createStarted();
        recipesByResult = RecipeModification.buildRecipeResultMap();
        logger.debug("Built recipe by result map for {} recipes in {}", (Object)recipeManager.m_44051_().size(), (Object)timer);
        timer.reset().start();
        for (Consumer recipeManagerCallback : recipeManagerCallbacks) {
            recipeManagerCallback.accept(recipeManager);
        }
        logger.debug("Executed {} recipe manager callbacks in {}", (Object)recipeManagerCallbacks.size(), (Object)timer);
        timer.reset().start();
        int modified = 0;
        logger.info("Found {} recipe modifiers in datapacks, {} total", (Object)modifiersFromDatapack.size(), (Object)RecipeModification.getAllModifiers().size());
        for (Recipe recipe : recipeManager.m_44051_()) {
            RegistryAccess registryAccess;
            int appliedOnRecipe = RecipeModification.applyAllModifiers(recipe, registryAccess = RecipeModification.getRegistryAccess());
            if (appliedOnRecipe > 0) {
                logger.debug("Applied {} recipe modifiers to {}", (Object)appliedOnRecipe, (Object)recipe.m_6423_());
            }
            for (ResourceLocation id : toRemove) {
                if (!recipe.m_6423_().equals((Object)id)) continue;
                platform.removeRecipe((RecipeManagerAccessor)recipeManager, recipe.m_6423_());
            }
            modified += appliedOnRecipe;
        }
        logger.info("Modified {} recipes in {}", (Object)modified, (Object)timer);
    }

    private static int applyAllModifiers(Recipe<?> recipe, RegistryAccess registryAccess) {
        int appliedOnRecipe = 0;
        for (RecipeModifierHolder modifier : RecipeModification.getAllModifiers()) {
            try {
                if (!modifier.filter().shouldApply(recipe, registryAccess)) continue;
                RecipeHelper helper = RecipeModification.getPlatform().getHelper();
                modifier.apply(recipe, helper);
            }
            catch (Exception e) {
                RecipeModification.handleError(recipe, modifier, e);
            }
            ++appliedOnRecipe;
        }
        return appliedOnRecipe;
    }

    private static ImmutableMultimap<Item, Recipe<?>> buildRecipeResultMap() {
        ImmutableMultimap.Builder byResultBuilder = ImmutableMultimap.builder();
        for (Recipe recipe : recipeManager.m_44051_()) {
            ItemStack result = RecipeModification.tryGetResult(recipe, RecipeModification.getRegistryAccess());
            if (result == null) continue;
            byResultBuilder.put((Object)result.m_41720_(), (Object)recipe);
        }
        return byResultBuilder.build();
    }

    private static void handleError(Recipe<?> recipe, RecipeModifierHolder modifier, Exception e) {
        if (platform.isDevelopmentEnvironment()) {
            logger.error("Failed to apply modifier '{}' to recipe '{}'", new Object[]{modifier.id(), recipe.m_6423_(), e});
        } else {
            logger.warn("Failed to apply modifier '{}' to recipe '{}'", (Object)modifier.id(), (Object)recipe.m_6423_());
            logger.debug("Exception:", (Throwable)e);
        }
    }

    static {
        recipeManagerCallbacks = NonNullList.m_122779_();
        toRemove = NonNullList.m_122779_();
        modifiers = NonNullList.m_122779_();
        resultModifiers = NonNullList.m_122779_();
        resultItemOverrides = new IdentityHashMap();
    }
}

