/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.compat.jei.categorys;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfy.beachparty.client.gui.PalmBarGui;
import net.satisfy.beachparty.core.compat.jei.BeachpartyJEIPlugin;
import net.satisfy.beachparty.core.recipe.PalmBarRecipe;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class PalmBarCategory
implements IRecipeCategory<PalmBarRecipe> {
    public static final RecipeType<PalmBarRecipe> PALM_BAR = RecipeType.create((String)"beachparty", (String)"palm_bar_mixing", PalmBarRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public PalmBarCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(PalmBarGui.BG, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(PalmBarGui.BG, 176, 14, 24, 17).buildAnimated(250, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.PALM_BAR.get()).m_5456_().m_7968_());
    }

    public void draw(PalmBarRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 53, 22);
    }

    @NotNull
    public RecipeType<PalmBarRecipe> getRecipeType() {
        return PALM_BAR;
    }

    @NotNull
    public Component getTitle() {
        return ((Block)ObjectRegistry.PALM_BAR.get()).m_49954_();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PalmBarRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = ingredients.size();
        if (s > 0) {
            BeachpartyJEIPlugin.addSlot(builder, 12, 12, (Ingredient)ingredients.get(0));
        }
        if (s > 1) {
            BeachpartyJEIPlugin.addSlot(builder, 12, 30, (Ingredient)ingredients.get(1));
        }
        if (s > 2) {
            BeachpartyJEIPlugin.addSlot(builder, 30, 12, (Ingredient)ingredients.get(2));
        }
        if (s > 3) {
            BeachpartyJEIPlugin.addSlot(builder, 30, 30, (Ingredient)ingredients.get(3));
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 22).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }
}

