/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge.client.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.model.RubberRingColoredModel;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CuriosRubberRingRenderer
implements ICurioRenderer {
    private final RubberRingColoredModel<LivingEntity> model = new RubberRingColoredModel(Minecraft.m_91087_().m_167973_().m_171103_(RubberRingColoredModel.LAYER_LOCATION));

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!slotContext.identifier().equals("belt")) {
            return;
        }
        if (stack.m_41619_() || !this.isRubberRing(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity == null) {
            return;
        }
        ResourceLocation texture = this.getRingTexture(stack);
        this.model.m_6973_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        matrixStack.m_85836_();
        if (livingEntity.m_6047_()) {
            matrixStack.m_252880_(0.1f, -0.7f, -1.0f);
            matrixStack.m_252781_(new Quaternionf().rotationX((float)Math.toRadians(20.0)));
        } else {
            matrixStack.m_252880_(0.1f, -1.4f, -0.5f);
        }
        this.model.m_7695_(matrixStack, renderTypeBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    private boolean isRubberRing(ItemStack stack) {
        return stack.m_150930_((Item)ObjectRegistry.RUBBER_RING_BLUE.get()) || stack.m_150930_((Item)ObjectRegistry.RUBBER_RING_PINK.get()) || stack.m_150930_((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get());
    }

    private ResourceLocation getRingTexture(ItemStack stack) {
        if (stack.m_150930_((Item)ObjectRegistry.RUBBER_RING_PINK.get())) {
            return new BeachpartyIdentifier("textures/models/armor/rubber_ring_pink.png");
        }
        if (stack.m_150930_((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get())) {
            return new BeachpartyIdentifier("textures/models/armor/rubber_ring_stripped.png");
        }
        return new BeachpartyIdentifier("textures/models/armor/rubber_ring_blue.png");
    }
}

