/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.collapsible;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CollapsibleConfigManager {
    private static final CollapsibleConfigManager INSTANCE = new CollapsibleConfigManager();
    private CollapsibleConfigObject object;

    public CollapsibleConfigManager() {
        AutoConfig.register(CollapsibleConfigObject.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
    }

    public static CollapsibleConfigManager getInstance() {
        return INSTANCE;
    }

    public void saveConfig() {
        AutoConfig.getConfigHolder(CollapsibleConfigObject.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return InteractionResult.PASS;
        });
        AutoConfig.getConfigHolder(CollapsibleConfigObject.class).save();
    }

    public CollapsibleConfigObject getConfig() {
        if (this.object == null) {
            this.object = (CollapsibleConfigObject)AutoConfig.getConfigHolder(CollapsibleConfigObject.class).getConfig();
        }
        return this.object;
    }

    public void syncFrom(ConfigManagerImpl manager) {
        manager.saveConfig();
        this.saveConfig();
    }

    @Config(name="roughlyenoughitems/collapsible")
    @OnlyIn(value=Dist.CLIENT)
    public static final class CollapsibleConfigObject
    implements ConfigData {
        public List<ResourceLocation> disabledGroups = new ArrayList<ResourceLocation>();
        public List<CustomGroup> customGroups = new ArrayList<CustomGroup>();
    }

    public static final class CustomGroup {
        public ResourceLocation id = new ResourceLocation("missingno");
        public String name = "Invalid";
        public List<EntryStackProvider<?>> stacks = new ArrayList();

        public CustomGroup() {
        }

        public CustomGroup(ResourceLocation id, String name, List<EntryStackProvider<?>> stacks) {
            this.id = id;
            this.name = name;
            this.stacks = stacks;
        }

        public CustomGroup copy() {
            return new CustomGroup(this.id, this.name, new ArrayList(this.stacks));
        }
    }
}

