/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.architectury.registry.ReloadListenerRegistry;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.List;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CachedEntryListRender {
    public static final int RESOLUTION = 64;
    public static DynamicTexture cachedTexture;
    public static ResourceLocation cachedTextureLocation;
    public static Long2LongMap hash;
    public static LazyResettable<RenderType> renderType;

    public static void refresh() {
        if (ConfigObject.getInstance().doesCacheEntryRendering()) {
            InternalLogger.getInstance().info("Refreshing cached entry list texture...");
        }
        if (cachedTextureLocation != null) {
            Minecraft.m_91087_().m_91097_().m_118513_(cachedTextureLocation);
            cachedTextureLocation = null;
            renderType.reset();
        }
        if (cachedTexture != null) {
            cachedTexture.close();
            cachedTexture = null;
        }
        hash = new Long2LongOpenHashMap();
    }

    @Nullable
    public static Sprite get(EntryStack<?> stack) {
        if (stack.getType() == VanillaEntryTypes.ITEM) {
            long hashExact;
            long hashOrDefault;
            if (stack.getNullable(EntryStack.Settings.RENDERER) != null) {
                return null;
            }
            if (cachedTexture == null) {
                CachedEntryListRender.prepare();
            }
            if ((hashOrDefault = hash.getOrDefault(hashExact = EntryStacks.hashExact(stack), -1L)) != -1L) {
                int x = (int)(hashOrDefault >> 32);
                int y = (int)(hashOrDefault & 0xFFFFFFFFL);
                float width = cachedTexture.m_117991_().m_84982_();
                float height = cachedTexture.m_117991_().m_84982_();
                return new Sprite((float)(x * 64) / width, (float)((x + 1) * 64) / width, (float)(y * 64) / height, (float)((y + 1) * 64) / height);
            }
        }
        return null;
    }

    private static void prepare() {
        int side = 4;
        List<EntryStack<?>> list = EntryRegistry.getInstance().getPreFilteredList();
        while (side * side < list.size()) {
            ++side;
        }
        int width = side * 64;
        int height = side * 64;
        InternalLogger.getInstance().info("Preparing cached texture with size %sx%s for %sx%s entries", width, height, side, side);
        hash = new Long2LongOpenHashMap(list.size() + 10);
        Minecraft minecraft = Minecraft.m_91087_();
        TextureTarget target = new TextureTarget(width, height, true, false);
        target.m_83947_(true);
        Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.f_276633_);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        Rectangle bounds = new Rectangle();
        GuiGraphics graphics = new GuiGraphics(minecraft, minecraft.m_91269_().m_110104_());
        int index = 0;
        for (EntryStack<?> stack : list) {
            int x = index % side;
            int y = index / side;
            bounds.setBounds(x * 64, y * 64, 64, 64);
            stack.getDefinition().getRenderer().render(stack, graphics, bounds, -1, -1, 0.0f);
            hash.put(EntryStacks.hashExact(stack), CachedEntryListRender.pack(x, y));
            ++index;
        }
        NativeImage nativeImage = new NativeImage(width, height, false);
        RenderSystem.bindTexture((int)target.m_83975_());
        nativeImage.m_85045_(0, false);
        nativeImage.m_85122_();
        cachedTexture = new DynamicTexture(nativeImage);
        cachedTextureLocation = minecraft.m_91097_().m_118490_("rei_cached_entries", cachedTexture);
        renderType.reset();
        target.m_83930_();
        Minecraft.m_91087_().f_91060_.m_173014_();
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static long pack(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    static {
        hash = new Long2LongOpenHashMap();
        renderType = new LazyResettable(() -> RenderType.m_173209_((String)"rei_cache", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(cachedTextureLocation, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172817_)).m_110691_(false)));
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (barrier, resourceManager, preparationProfiler, reloadProfiler, preparationExecutor, reloadExecutor) -> barrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(CachedEntryListRender::refresh, reloadExecutor));
    }

    public static class Sprite {
        public final float u0;
        public final float u1;
        public final float v0;
        public final float v1;

        public Sprite(float u0, float u1, float v0, float v1) {
            this.u0 = u0;
            this.u1 = u1;
            this.v0 = v0;
            this.v1 = v1;
        }
    }
}

