/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.bundle;

import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public final class BundleFeatures {
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_SELECTED_ITEM = "SelectedItem";
    public static final int MAX_WEIGHT = 64;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int NO_SELECTED_ITEM = -1;

    public static boolean onBundleUpdate() {
        return (Boolean)VanillaBackport.COMMON_CONFIG.hasUpdatedBundles.get();
    }

    public static boolean canItemBeInBundle(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_().m_142095_();
    }

    @Nullable
    public static ItemStack removeOne(ItemStack bundle) {
        ListTag items;
        CompoundTag tag = bundle.m_41784_();
        if (tag.m_128441_(TAG_ITEMS) && !(items = tag.m_128437_(TAG_ITEMS, 10)).isEmpty()) {
            int index;
            int selectedItem = tag.m_128451_(TAG_SELECTED_ITEM);
            int n = index = BundleFeatures.isValidIndex(selectedItem, items.size()) ? selectedItem : 0;
            if (!BundleFeatures.isValidIndex(index, items.size())) {
                return null;
            }
            CompoundTag itemTag = items.m_128728_(index);
            ItemStack removedItem = ItemStack.m_41712_((CompoundTag)itemTag);
            items.remove(index);
            if (items.isEmpty()) {
                bundle.m_41749_(TAG_ITEMS);
            }
            BundleFeatures.setSelectedItem(bundle, -1);
            return removedItem;
        }
        return null;
    }

    public static Stream<ItemStack> getContents(ItemStack bundle) {
        CompoundTag tag = bundle.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ITEMS)) {
            return Stream.empty();
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        return items.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public static int getWeight(ItemStack stack) {
        if (stack.m_204117_(ModItemTags.BUNDLES)) {
            return 4 + BundleFeatures.getContentWeight(stack);
        }
        return 64 / stack.m_41741_();
    }

    public static int getContentWeight(ItemStack bundle) {
        return BundleFeatures.getContents(bundle).mapToInt(item -> BundleFeatures.getWeight(item) * item.m_41613_()).sum();
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag items) {
        return items.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(tag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)tag), (ItemStack)stack)).findFirst();
    }

    public static void setSelectedItem(ItemStack bundle, int index) {
        CompoundTag tag = bundle.m_41784_();
        tag.m_128405_(TAG_SELECTED_ITEM, index);
    }

    public static int getSelectedItem(ItemStack bundle) {
        ListTag items;
        CompoundTag tag = bundle.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_SELECTED_ITEM)) {
            return -1;
        }
        int selectedItem = tag.m_128451_(TAG_SELECTED_ITEM);
        if (!BundleFeatures.isValidIndex(selectedItem, (items = tag.m_128437_(TAG_ITEMS, 10)).size())) {
            return -1;
        }
        return selectedItem;
    }

    public static int tryInsert(ItemStack bundle, ItemStack item) {
        if (!BundleFeatures.canItemBeInBundle(item)) {
            return 0;
        }
        CompoundTag tag = bundle.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            tag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        int currentWeight = BundleFeatures.getContentWeight(bundle);
        int itemWeight = BundleFeatures.getWeight(item);
        int maxToAdd = Math.min(item.m_41613_(), (64 - currentWeight) / itemWeight);
        if (maxToAdd == 0) {
            return 0;
        }
        Optional<CompoundTag> matchingItem = BundleFeatures.getMatchingItem(item, items);
        if (matchingItem.isPresent()) {
            CompoundTag itemTag = matchingItem.get();
            ItemStack existingStack = ItemStack.m_41712_((CompoundTag)itemTag);
            existingStack.m_41769_(maxToAdd);
            existingStack.m_41739_(itemTag);
            items.remove((Object)itemTag);
            items.add(0, (Tag)itemTag);
        } else {
            ItemStack newStack = item.m_255036_(maxToAdd);
            CompoundTag newTag = new CompoundTag();
            newStack.m_41739_(newTag);
            items.add(0, (Tag)newTag);
        }
        item.m_41774_(maxToAdd);
        return maxToAdd;
    }

    public static int tryTransfer(ItemStack bundle, Slot slot, Player player) {
        ItemStack slotStack = slot.m_7993_();
        if (!BundleFeatures.canItemBeInBundle(slotStack)) {
            return 0;
        }
        int currentWeight = BundleFeatures.getContentWeight(bundle);
        int itemWeight = BundleFeatures.getWeight(slotStack);
        int maxToAdd = Math.min(slotStack.m_41613_(), (64 - currentWeight) / itemWeight);
        if (maxToAdd == 0) {
            return 0;
        }
        ItemStack takenStack = slot.m_150647_(slotStack.m_41613_(), maxToAdd, player);
        return BundleFeatures.tryInsert(bundle, takenStack);
    }

    public static void toggleSelectedItem(ItemStack bundle, int index) {
        CompoundTag tag = bundle.m_41784_();
        int selected0 = tag.m_128451_(TAG_SELECTED_ITEM);
        if (!tag.m_128441_(TAG_ITEMS)) {
            BundleFeatures.setSelectedItem(bundle, -1);
            return;
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        if (!BundleFeatures.isValidIndex(index, items.size())) {
            BundleFeatures.setSelectedItem(bundle, -1);
            return;
        }
        boolean outsideBounds = index < 0 || index >= items.size();
        int selected = selected0 != index && !outsideBounds ? index : -1;
        BundleFeatures.setSelectedItem(bundle, selected);
    }

    private static boolean isValidIndex(int index, int size) {
        return index >= 0 && index < size;
    }

    public static int getNumberOfItemsToShow(ItemStack bundle) {
        CompoundTag tag = bundle.m_41783_();
        if (tag != null && tag.m_128441_(TAG_ITEMS)) {
            return BundleFeatures.getItemsToShow(tag.m_128437_(TAG_ITEMS, 10).stream().toList());
        }
        return 0;
    }

    public static int getItemsToShow(List<?> items) {
        int contents = items.size();
        int maxDisplay = contents > 12 ? 11 : 12;
        int remainder = contents % 4;
        int padding = remainder == 0 ? 0 : 4 - remainder;
        return Math.min(contents, maxDisplay - padding);
    }

    public static ItemStack getSelectedItemStack(ItemStack bundle) {
        int selectedIndex = BundleFeatures.getSelectedItem(bundle);
        if (selectedIndex == -1) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = bundle.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ITEMS)) {
            return ItemStack.f_41583_;
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        if (!BundleFeatures.isValidIndex(selectedIndex, items.size())) {
            return ItemStack.f_41583_;
        }
        CompoundTag itemTag = items.m_128728_(selectedIndex);
        return ItemStack.m_41712_((CompoundTag)itemTag);
    }

    public static Item getByColor(DyeColor dyeColor) {
        return switch (dyeColor) {
            case DyeColor.WHITE -> ModItems.WHITE_BUNDLE.get();
            case DyeColor.ORANGE -> ModItems.ORANGE_BUNDLE.get();
            case DyeColor.MAGENTA -> ModItems.MAGENTA_BUNDLE.get();
            case DyeColor.LIGHT_BLUE -> ModItems.LIGHT_BLUE_BUNDLE.get();
            case DyeColor.YELLOW -> ModItems.YELLOW_BUNDLE.get();
            case DyeColor.LIME -> ModItems.LIME_BUNDLE.get();
            case DyeColor.PINK -> ModItems.PINK_BUNDLE.get();
            case DyeColor.GRAY -> ModItems.GRAY_BUNDLE.get();
            case DyeColor.LIGHT_GRAY -> ModItems.LIGHT_GRAY_BUNDLE.get();
            case DyeColor.CYAN -> ModItems.CYAN_BUNDLE.get();
            case DyeColor.BLUE -> ModItems.BLUE_BUNDLE.get();
            case DyeColor.BROWN -> ModItems.BROWN_BUNDLE.get();
            case DyeColor.GREEN -> ModItems.GREEN_BUNDLE.get();
            case DyeColor.RED -> ModItems.RED_BUNDLE.get();
            case DyeColor.BLACK -> ModItems.BLACK_BUNDLE.get();
            case DyeColor.PURPLE -> ModItems.PURPLE_BUNDLE.get();
            default -> Items.f_151058_;
        };
    }
}

