/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MossyCarpetBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty BASE = BlockStateProperties.f_61427_;
    private static final EnumProperty<WallSide> NORTH = BlockStateProperties.f_61379_;
    private static final EnumProperty<WallSide> EAST = BlockStateProperties.f_61378_;
    private static final EnumProperty<WallSide> SOUTH = BlockStateProperties.f_61380_;
    private static final EnumProperty<WallSide> WEST = BlockStateProperties.f_61381_;
    private static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
    })));
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHORT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0);
    private static final VoxelShape EAST_SHORT_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape NORTH_SHORT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0);
    private static final VoxelShape SOUTH_SHORT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MossyCarpetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(true))).m_61124_(NORTH, (Comparable)WallSide.NONE)).m_61124_(EAST, (Comparable)WallSide.NONE)).m_61124_(SOUTH, (Comparable)WallSide.NONE)).m_61124_(WEST, (Comparable)WallSide.NONE));
        this.shapesCache = ImmutableMap.copyOf(this.m_49965_().m_61056_().stream().collect(Collectors.toMap(Function.identity(), MossyCarpetBlock::calculateShape)));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape shape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)BASE)).booleanValue()) {
            shape = DOWN_AABB;
        }
        shape = switch ((WallSide)state.m_61143_(NORTH)) {
            default -> throw new IncompatibleClassChangeError();
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHORT_AABB);
            case WallSide.TALL -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_AABB);
        };
        shape = switch ((WallSide)state.m_61143_(SOUTH)) {
            default -> throw new IncompatibleClassChangeError();
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHORT_AABB);
            case WallSide.TALL -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_AABB);
        };
        shape = switch ((WallSide)state.m_61143_(EAST)) {
            default -> throw new IncompatibleClassChangeError();
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHORT_AABB);
            case WallSide.TALL -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_AABB);
        };
        shape = switch ((WallSide)state.m_61143_(WEST)) {
            default -> throw new IncompatibleClassChangeError();
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHORT_AABB);
            case WallSide.TALL -> Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_AABB);
        };
        return shape.m_83281_() ? Shapes.m_83144_() : shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)BASE) != false ? DOWN_AABB : Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState floorState = level.m_8055_(pos.m_7495_());
        return ((Boolean)state.m_61143_((Property)BASE)).booleanValue() ? !floorState.m_60795_() : floorState.m_60713_((Block)this) && (Boolean)floorState.m_61143_((Property)BASE) != false;
    }

    private static boolean hasFaces(BlockState state) {
        if (((Boolean)state.m_61143_((Property)BASE)).booleanValue()) {
            return true;
        }
        return PROPERTY_BY_DIRECTION.values().stream().anyMatch(property -> state.m_61143_((Property)property) != WallSide.NONE);
    }

    private static boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        BlockPos adjacent = pos.m_121945_(direction);
        BlockState adjacentState = level.m_8055_(adjacent);
        return direction != Direction.UP && MultifaceBlock.m_153829_((BlockGetter)level, (Direction)direction, (BlockPos)adjacent, (BlockState)adjacentState);
    }

    private static BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos, boolean flag) {
        BlockState aboveState = null;
        BlockState belowState = null;
        flag |= ((Boolean)state.m_61143_((Property)BASE)).booleanValue();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide;
            EnumProperty<WallSide> property = MossyCarpetBlock.getPropertyForFace(direction);
            WallSide wallSide2 = MossyCarpetBlock.canSupportAtFace(level, pos, direction) ? (flag ? WallSide.LOW : (WallSide)state.m_61143_(property)) : (wallSide = WallSide.NONE);
            if (wallSide == WallSide.LOW) {
                if (aboveState == null) {
                    aboveState = level.m_8055_(pos.m_7494_());
                }
                if (aboveState.m_60713_(ModBlocks.PALE_MOSS_CARPET.get()) && aboveState.m_61143_(property) != WallSide.NONE && !((Boolean)aboveState.m_61143_((Property)BASE)).booleanValue()) {
                    wallSide = WallSide.TALL;
                }
                if (!((Boolean)state.m_61143_((Property)BASE)).booleanValue()) {
                    if (belowState == null) {
                        belowState = level.m_8055_(pos.m_7495_());
                    }
                    if (belowState.m_60713_(ModBlocks.PALE_MOSS_CARPET.get()) && belowState.m_61143_(property) == WallSide.NONE) {
                        wallSide = WallSide.NONE;
                    }
                }
            }
            state = (BlockState)state.m_61124_(property, (Comparable)wallSide);
        }
        return state;
    }

    public static void placeAt(LevelAccessor level, BlockPos pos, RandomSource random, int flag) {
        BlockState base = ModBlocks.PALE_MOSS_CARPET.get().m_49966_();
        BlockState updatedState = MossyCarpetBlock.getUpdatedState(base, (BlockGetter)level, pos, true);
        level.m_7731_(pos, updatedState, flag);
        BlockState topperState = MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> ((RandomSource)random).m_188499_());
        if (!topperState.m_60795_()) {
            level.m_7731_(pos.m_7494_(), topperState, flag);
            BlockState reUpdatedState = MossyCarpetBlock.getUpdatedState(updatedState, (BlockGetter)level, pos, true);
            level.m_7731_(pos, reUpdatedState, flag);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.f_46443_) {
            RandomSource random = level.m_213780_();
            BlockState topperState = MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> ((RandomSource)random).m_188499_());
            if (!topperState.m_60795_()) {
                level.m_7731_(pos.m_7494_(), topperState, 3);
            }
        }
    }

    private static BlockState createTopperWithSideChance(BlockGetter level, BlockPos pos, BooleanSupplier flag) {
        BlockPos above = pos.m_7494_();
        BlockState aboveState = level.m_8055_(above);
        boolean isCarpet = aboveState.m_60713_(ModBlocks.PALE_MOSS_CARPET.get());
        if (!(isCarpet && ((Boolean)aboveState.m_61143_((Property)BASE)).booleanValue() || !isCarpet && !aboveState.m_247087_())) {
            BlockState baselessCarpet = (BlockState)ModBlocks.PALE_MOSS_CARPET.get().m_49966_().m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false));
            BlockState updatedState = MossyCarpetBlock.getUpdatedState(baselessCarpet, level, pos.m_7494_(), true);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                EnumProperty<WallSide> property = MossyCarpetBlock.getPropertyForFace(direction);
                if (updatedState.m_61143_(property) == WallSide.NONE || flag.getAsBoolean()) continue;
                updatedState = (BlockState)updatedState.m_61124_(property, (Comparable)WallSide.NONE);
            }
            return MossyCarpetBlock.hasFaces(updatedState) && updatedState != aboveState ? updatedState : Blocks.f_50016_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return MossyCarpetBlock.getUpdatedState(this.m_49966_(), (BlockGetter)context.m_43725_(), context.m_8083_(), true);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState updatedState = MossyCarpetBlock.getUpdatedState(state, (BlockGetter)level, pos, false);
        return !MossyCarpetBlock.hasFaces(updatedState) ? Blocks.f_50016_.m_49966_() : updatedState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BASE, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((WallSide)state.m_61143_(SOUTH)))).m_61124_(EAST, (Comparable)((WallSide)state.m_61143_(WEST)))).m_61124_(SOUTH, (Comparable)((WallSide)state.m_61143_(NORTH)))).m_61124_(WEST, (Comparable)((WallSide)state.m_61143_(EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((WallSide)state.m_61143_(EAST)))).m_61124_(EAST, (Comparable)((WallSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((WallSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((WallSide)state.m_61143_(NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((WallSide)state.m_61143_(WEST)))).m_61124_(EAST, (Comparable)((WallSide)state.m_61143_(NORTH)))).m_61124_(SOUTH, (Comparable)((WallSide)state.m_61143_(EAST)))).m_61124_(WEST, (Comparable)((WallSide)state.m_61143_(SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((WallSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((WallSide)state.m_61143_(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((WallSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((WallSide)state.m_61143_(EAST)));
            default -> super.m_6943_(state, mirror);
        };
    }

    @Nullable
    public static EnumProperty<WallSide> getPropertyForFace(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)BASE) != false && !MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> true).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState topperState = MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> true);
        if (!topperState.m_60795_()) {
            level.m_7731_(pos.m_7494_(), topperState, 3);
        }
    }
}

