/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.items;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.common.api.bundle.BundleSelectionTooltip;
import com.blackgear.vanillabackport.core.util.ColorUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BundleItem.class})
public abstract class BundleItemMixin {
    @Unique
    private static final int FULL_BAR_COLOR = ColorUtils.colorFromFloat(1.0f, 1.0f, 0.33f, 0.33f);
    @Unique
    private static final int BAR_COLOR = ColorUtils.colorFromFloat(1.0f, 0.44f, 0.53f, 1.0f);

    @Shadow
    protected abstract void m_186351_(Entity var1);

    @Shadow
    protected abstract void m_186342_(Entity var1);

    @Inject(method={"overrideStackedOnOther"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onOverrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        ItemStack itemInSlot = slot.m_7993_();
        if (action == ClickAction.PRIMARY && !itemInSlot.m_41619_()) {
            if (BundleFeatures.tryTransfer(stack, slot, player) > 0) {
                this.m_186351_((Entity)player);
            } else {
                this.playInsertFailSound((Entity)player);
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else if (action == ClickAction.SECONDARY && itemInSlot.m_41619_()) {
            ItemStack removed = BundleFeatures.removeOne(stack);
            if (removed != null) {
                ItemStack inserted = slot.m_150659_(removed);
                if (inserted.m_41613_() > 0) {
                    BundleFeatures.tryInsert(stack, inserted);
                } else {
                    this.m_186342_((Entity)player);
                }
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"overrideOtherStackedOnMe"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onOverrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess slotAccess, CallbackInfoReturnable<Boolean> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        if (action == ClickAction.PRIMARY && other.m_41619_()) {
            BundleFeatures.toggleSelectedItem(stack, -1);
            cir.setReturnValue((Object)false);
        } else if (action == ClickAction.PRIMARY && !other.m_41619_()) {
            if (slot.m_150651_(player) && BundleFeatures.tryInsert(stack, other) > 0) {
                this.m_186351_((Entity)player);
            } else {
                this.playInsertFailSound((Entity)player);
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else if (action == ClickAction.SECONDARY && other.m_41619_()) {
            ItemStack removed;
            if (slot.m_150651_(player) && (removed = BundleFeatures.removeOne(stack)) != null) {
                this.m_186342_((Entity)player);
                slotAccess.m_142104_(removed);
            }
            this.broadcastChangesOnContainerMenu(player);
            cir.setReturnValue((Object)true);
        } else {
            BundleFeatures.toggleSelectedItem(stack, -1);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"dropContents"}, at={@At(value="HEAD")}, cancellable=true)
    private static void vb$dropContents(ItemStack stack, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        Optional<ItemStack> taken = BundleItemMixin.removeOneFromBundle(stack);
        if (taken.isPresent()) {
            player.m_36176_(taken.get(), true);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private static Optional<ItemStack> removeOneFromBundle(ItemStack stack) {
        ItemStack removed = BundleFeatures.removeOne(stack);
        if (removed != null) {
            return Optional.of(removed);
        }
        return Optional.empty();
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onGetBarColor(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        cir.setReturnValue((Object)(BundleFeatures.getContentWeight(stack) >= 64 ? FULL_BAR_COLOR : BAR_COLOR));
    }

    @Inject(method={"getBarWidth"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onGetBarWidth(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        int weight = BundleFeatures.getContentWeight(stack);
        cir.setReturnValue((Object)Math.min(1 + weight * 12 / 64, 13));
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onAppendHoverText(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced, CallbackInfo ci) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"getTooltipImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onGetTooltipImage(ItemStack stack, CallbackInfoReturnable<Optional<TooltipComponent>> cir) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        NonNullList items = NonNullList.m_122779_();
        BundleFeatures.getContents(stack).forEach(arg_0 -> items.add(arg_0));
        cir.setReturnValue(Optional.of(new BundleSelectionTooltip((NonNullList<ItemStack>)items, BundleFeatures.getContentWeight(stack), BundleFeatures.getSelectedItem(stack))));
    }

    @Unique
    private void playInsertFailSound(Entity entity) {
        entity.m_5496_(ModSoundEvents.BUNDLE_INSERT_FAIL.get(), 1.0f, 1.0f);
    }

    @Unique
    private void broadcastChangesOnContainerMenu(Player player) {
        AbstractContainerMenu menu = player.f_36096_;
        if (menu.m_6875_(player)) {
            menu.m_6199_((Container)player.m_150109_());
        }
    }
}

