/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.network;

import com.blackgear.platform.core.network.base.Packet;
import com.blackgear.platform.core.network.base.PacketContext;
import com.blackgear.platform.core.network.base.PacketHandler;
import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.core.VanillaBackport;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public record ServerboundSelectBundleItemPacket(int slotId, int selectedItemIndex) implements Packet<ServerboundSelectBundleItemPacket>
{
    public static final ResourceLocation ID = VanillaBackport.resource("select_bundle_item");
    public static final Handler HANDLER = new Handler();

    public ResourceLocation getId() {
        return ID;
    }

    public PacketHandler<ServerboundSelectBundleItemPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<ServerboundSelectBundleItemPacket> {
        public void encode(ServerboundSelectBundleItemPacket packet, FriendlyByteBuf buf) {
            buf.m_130130_(packet.slotId);
            buf.m_130130_(packet.selectedItemIndex);
        }

        public ServerboundSelectBundleItemPacket decode(FriendlyByteBuf buf) {
            int slotId = buf.m_130242_();
            int selectedItemIndex = buf.m_130242_();
            if (selectedItemIndex < 0 && selectedItemIndex != -1) {
                throw new IllegalArgumentException("Invalid selectedItemIndex: " + selectedItemIndex);
            }
            return new ServerboundSelectBundleItemPacket(slotId, selectedItemIndex);
        }

        public PacketContext handle(ServerboundSelectBundleItemPacket packet) {
            return (player, level) -> {
                NonNullList slots = player.f_36096_.f_38839_;
                int slotId = packet.slotId;
                int selectedItemIndex = packet.selectedItemIndex;
                if (slotId >= 0 && slotId < slots.size()) {
                    ItemStack stack = ((Slot)slots.get(slotId)).m_7993_();
                    BundleFeatures.toggleSelectedItem(stack, selectedItemIndex);
                }
            };
        }
    }
}

