/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.shearpin;

import com.google.common.base.Predicates;
import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.AbstractBEShaftBlock;
import com.hlysine.create_connected.content.shearpin.ShearPinBlockEntity;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ShearPinBlock
extends AbstractBEShaftBlock<ShearPinBlockEntity> {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ShearPinBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<ShearPinBlockEntity> getBlockEntityClass() {
        return ShearPinBlockEntity.class;
    }

    public BlockEntityType<? extends ShearPinBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.SHEAR_PIN.get();
    }

    public void m_213897_(@NotNull BlockState pState, ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (!(be instanceof ShearPinBlockEntity)) {
            return;
        }
        ShearPinBlockEntity kte = (ShearPinBlockEntity)be;
        if (!kte.isOverStressed()) {
            return;
        }
        if (!pLevel.f_46443_) {
            pLevel.m_46961_(pPos, false);
            Vec3 center = pPos.m_252807_();
            pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, center.f_82479_, center.f_82480_, center.f_82481_, 5, 0.1, 0.1, 0.1, 0.05);
            AdvancementBehaviour.tryAward((BlockEntity)kte, CCAdvancements.SHEAR_PIN);
        }
    }

    public static boolean isShaft(BlockState state) {
        return CCBlocks.SHEAR_PIN.has(state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return AllShapes.SIX_VOXEL_POLE.get((Direction.Axis)state.m_61143_((Property)AXIS));
    }

    public float getParticleTargetRadius() {
        return 0.35f;
    }

    public float getParticleInitialRadius() {
        return 0.125f;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super((Predicate)Predicates.or((com.google.common.base.Predicate)Predicates.or(arg_0 -> ((BlockEntry)AllBlocks.SHAFT).has(arg_0), arg_0 -> ((BlockEntry)AllBlocks.POWERED_SHAFT).has(arg_0)), arg_0 -> CCBlocks.SHEAR_PIN.has(arg_0)), state -> (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS), (Property)RotatedPillarKineticBlock.AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof AbstractSimpleShaftBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> ShaftBlock.pickCorrectShaftType((BlockState)s, (Level)world, (BlockPos)offset.getBlockPos())));
            }
            return offset;
        }
    }
}

