/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mod_compat.IrisShadowPassDetection;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.models.parts.EMFModelPartVanilla;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class EMFModelPart
extends ModelPart {
    public ResourceLocation textureOverride;
    protected long lastTextureOverride = -1L;
    public boolean isSetByAnimation = false;

    public EMFModelPart(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
        this.f_104212_ = new ObjectArrayList(cuboids);
        this.f_104213_ = new Object2ObjectOpenHashMap(children);
    }

    public void processArmItemOverrides(PoseStack matrices) {
        matrices.m_85836_();
        this.m_104299_(matrices);
        this.f_104213_.values().forEach(v -> ((EMFModelPart)((Object)v)).processArmItemOverrides(matrices));
        matrices.m_85849_();
    }

    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        try {
            EMFConfig.RenderModeChoice choice = ((EMFConfig)EMF.config().getConfig()).getRenderModeFor(EMFAnimationEntityContext.getEMFEntity());
            if (choice == EMFConfig.RenderModeChoice.NORMAL) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                return;
            }
            if (((EMFConfig)EMF.config().getConfig()).onlyDebugRenderOnHover && !EMFAnimationEntityContext.isClientHovered()) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                return;
            }
            switch (choice) {
                case GREEN: {
                    this.renderDebugTinted(matrices, vertices, light, overlay, red, green, blue, alpha);
                    break;
                }
                case LINES: {
                    this.renderBoxes(matrices, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_()));
                    break;
                }
                case LINES_AND_TEXTURE: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                    this.renderBoxesNoChildren(matrices, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_()), 1.0f);
                    break;
                }
                case LINES_AND_TEXTURE_FLASH: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, red, green, blue, alpha);
                    float flash = (Mth.m_14031_((float)((float)System.currentTimeMillis() / 1000.0f)) + 1.0f) / 2.0f;
                    this.renderBoxesNoChildren(matrices, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_()), flash);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderDebugTinted(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        float flash = Math.abs(Mth.m_14031_((float)((float)System.currentTimeMillis() / 1000.0f)));
        this.renderWithTextureOverride(matrices, vertices, light, overlay, flash, green, flash, alpha);
    }

    void renderWithTextureOverride(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.textureOverride == null || this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
        } else if (light != 0xF000F1 && !ETFRenderContext.isIsInSpecialRenderOverlayPhase()) {
            if (EMFAnimationEntityContext.getEMFEntity() != null && EMFAnimationEntityContext.getEMFEntity().etf$isBlockEntity() && ETF.IRIS_DETECTED && IrisShadowPassDetection.getInstance().inShadowPass()) {
                this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
                return;
            }
            if (vertices instanceof ETFVertexConsumer) {
                ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertices;
                ETFTexture etfTextureTest = etfVertexConsumer.etf$getETFTexture();
                if (etfTextureTest != null && etfTextureTest.thisIdentifier.equals((Object)this.textureOverride)) {
                    this.renderLikeETF(matrices, vertices, light, overlay, red, green, blue, alpha);
                    return;
                }
                RenderType originalLayer = etfVertexConsumer.etf$getRenderLayer();
                if (originalLayer == null) {
                    return;
                }
                MultiBufferSource provider = etfVertexConsumer.etf$getProvider();
                if (provider == null) {
                    return;
                }
                this.renderTextureOverrideWithoutReset(provider, matrices, light, overlay, red, green, blue, alpha);
                provider.m_6299_(originalLayer);
            } else {
                MultiBufferSource.BufferSource provider = Minecraft.m_91087_().m_91269_().m_110104_();
                this.renderTextureOverrideWithoutReset((MultiBufferSource)provider, matrices, light, overlay, red, green, blue, alpha);
            }
        }
    }

    private void renderTextureOverrideWithoutReset(MultiBufferSource provider, PoseStack matrices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.lastTextureOverride = EMFManager.getInstance().entityRenderCount;
        RenderType layerModified = EMFAnimationEntityContext.getLayerFromRecentFactoryOrETFOverrideOrTranslucent(this.textureOverride);
        VertexConsumer newConsumer = provider.m_6299_(layerModified);
        this.renderLikeVanilla(matrices, newConsumer, light, overlay, red, green, blue, alpha);
        if (newConsumer instanceof ETFVertexConsumer) {
            ETFVertexConsumer newETFConsumer = (ETFVertexConsumer)newConsumer;
            ETFTexture etfTexture = newETFConsumer.etf$getETFTexture();
            if (etfTexture == null) {
                return;
            }
            ETFUtils2.RenderMethodForOverlay renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, red, green, blue, alpha);
            ETFUtils2.renderEmissive((ETFTexture)etfTexture, (MultiBufferSource)provider, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
            ETFUtils2.renderEnchanted((ETFTexture)etfTexture, (MultiBufferSource)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
        }
    }

    void renderLikeVanilla(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
            matrices.m_85836_();
            this.m_104299_(matrices);
            if (!this.f_233556_) {
                this.m_104290_(matrices.m_85850_(), vertices, light, overlay, red, green, blue, alpha);
            }
            for (ModelPart modelPart : this.f_104213_.values()) {
                modelPart.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.m_85849_();
        }
    }

    void renderLikeETF(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        ETFRenderContext.incrementCurrentModelPartDepth();
        this.renderLikeVanilla(matrices, vertices, light, overlay, red, green, blue, alpha);
        if (ETFRenderContext.getCurrentModelPartDepth() != 1) {
            ETFRenderContext.decrementCurrentModelPartDepth();
        } else {
            ETFVertexConsumer etfVertexConsumer;
            ETFTexture texture;
            if (ETFRenderContext.isCurrentlyRenderingEntity() && vertices instanceof ETFVertexConsumer && (texture = (etfVertexConsumer = (ETFVertexConsumer)vertices).etf$getETFTexture()) != null && (texture.isEmissive() || texture.isEnchanted())) {
                ETFUtils2.RenderMethodForOverlay renderMethodForOverlay;
                MultiBufferSource provider = etfVertexConsumer.etf$getProvider();
                RenderType layer = etfVertexConsumer.etf$getRenderLayer();
                if (provider != null && layer != null && ETFUtils2.renderEmissive((ETFTexture)texture, (MultiBufferSource)provider, (ETFUtils2.RenderMethodForOverlay)(renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, red, green, blue, alpha))) | ETFUtils2.renderEnchanted((ETFTexture)texture, (MultiBufferSource)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay)) {
                    provider.m_6299_(layer);
                }
            }
            ETFRenderContext.resetCurrentModelPartDepth();
        }
    }

    public void renderBoxes(PoseStack matrices, VertexConsumer vertices) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
            matrices.m_85836_();
            this.m_104299_(matrices);
            if (!this.f_233556_) {
                for (ModelPart.Cube cuboid : this.f_104212_) {
                    AABB box = new AABB((double)(cuboid.f_104335_ / 16.0f), (double)(cuboid.f_104336_ / 16.0f), (double)(cuboid.f_104337_ / 16.0f), (double)(cuboid.f_104338_ / 16.0f), (double)(cuboid.f_104339_ / 16.0f), (double)(cuboid.f_104340_ / 16.0f));
                    float[] col = this.debugBoxColor();
                    LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)vertices, (AABB)box.m_82400_(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)1.0f);
                }
            }
            for (ModelPart modelPart : this.f_104213_.values()) {
                if (!(modelPart instanceof EMFModelPart)) continue;
                EMFModelPart emf = (EMFModelPart)modelPart;
                emf.renderBoxes(matrices, vertices);
            }
            matrices.m_85849_();
        }
    }

    protected abstract float[] debugBoxColor();

    public void renderBoxesNoChildren(PoseStack matrices, VertexConsumer vertices, float alpha) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
            matrices.m_85836_();
            this.m_104299_(matrices);
            if (!this.f_233556_) {
                for (ModelPart.Cube cuboid : this.f_104212_) {
                    AABB box = new AABB((double)(cuboid.f_104335_ / 16.0f), (double)(cuboid.f_104336_ / 16.0f), (double)(cuboid.f_104337_ / 16.0f), (double)(cuboid.f_104338_ / 16.0f), (double)(cuboid.f_104339_ / 16.0f), (double)(cuboid.f_104340_ / 16.0f));
                    float[] col = this.debugBoxColor();
                    LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)vertices, (AABB)box.m_82400_(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)alpha);
                }
            }
            matrices.m_85849_();
        }
    }

    public void m_104290_(PoseStack.Pose pose, VertexConsumer vertexConsumer, int i, int j, float red, float green, float blue, float alpha) {
        for (ModelPart.Cube cuboid : this.f_104212_) {
            cuboid.m_171332_(pose, vertexConsumer, i, j, red, green, blue, alpha);
        }
    }

    public String simplePrintChildren(int depth) {
        StringBuilder mapper = new StringBuilder();
        mapper.append("\n  | ");
        mapper.append("- ".repeat(Math.max(0, depth)));
        mapper.append(this.toStringShort());
        for (ModelPart child : this.f_104213_.values()) {
            if (!(child instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)child;
            mapper.append(emf.simplePrintChildren(depth + 1));
        }
        return mapper.toString();
    }

    public String toStringShort() {
        return this.toString();
    }

    public String toString() {
        return "generic emf part";
    }

    public ModelPart getVanillaModelPartsOfCurrentState() {
        HashMap<String, ModelPart> children = new HashMap<String, ModelPart>();
        for (Map.Entry child : this.f_104213_.entrySet()) {
            Object v = child.getValue();
            if (!(v instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)((Object)v);
            children.put((String)child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        List<ModelPart.Cube> finalCubes = this.f_104212_.isEmpty() ? List.of(new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of())) : this.f_104212_;
        ModelPart part = new ModelPart((List)finalCubes, children);
        part.m_233560_(this.m_233566_());
        part.f_104203_ = this.f_104203_;
        part.f_104205_ = this.f_104205_;
        part.f_104204_ = this.f_104204_;
        part.f_104202_ = this.f_104202_;
        part.f_104201_ = this.f_104201_;
        part.f_104200_ = this.f_104200_;
        part.f_233553_ = this.f_233553_;
        part.f_233554_ = this.f_233554_;
        part.f_233555_ = this.f_233555_;
        return part;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        Object object = this;
        if (object instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)((Object)object);
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        for (ModelPart part : this.f_104213_.values()) {
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart emfPart = (EMFModelPart)part;
            String thisKey = "NULL_KEY_NAME";
            boolean addThis = false;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partCustom = (EMFModelPartCustom)part;
                thisKey = partCustom.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partVanilla = (EMFModelPartVanilla)part;
                thisKey = partVanilla.name;
                addThis = partVanilla.isOptiFinePartSpecified;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.putIfAbsent((Object)thisKey, (Object)emfPart);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.putIfAbsent((Object)(prefixableParents + ":" + thisKey), (Object)emfPart);
                mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public boolean hasAnimation() {
            return this.animation != null;
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

