/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.platform.PlatformHelper;

public class WineYears {
    public static final int YEARS_START = 0;
    public static final int MAX_LEVEL = PlatformHelper.getWineMaxLevel();
    public static final int START_DURATION = PlatformHelper.getWineStartDuration();
    public static final int DURATION_PER_YEAR = PlatformHelper.getWineDurationPerYear();
    public static final int DAYS_PER_YEAR = PlatformHelper.getWineDaysPerYear();
    public static final int YEARS_PER_EFFECT_LEVEL = PlatformHelper.getWineYearsPerEffectLevel();
    public static final int MAX_DURATION = PlatformHelper.getWineMaxDuration();
    public static final String TAG_YEAR = "Year";
    public static final String TAG_EFFECT_LEVEL = "EffectAmplifier";
    public static final String TAG_EFFECT_DURATION = "EffectDuration";

    public static int getYear(Level world) {
        return world != null ? 0 + (int)(world.m_46467_() / 24000L / (long)DAYS_PER_YEAR) : 0;
    }

    public static int getDays(Level world) {
        return world != null ? (int)(world.m_46467_() / 24000L) : 0;
    }

    public static int getWineAge(ItemStack wine, Level world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getYear(world) - y);
    }

    public static int getWineAgeDays(ItemStack wine, Level world) {
        int y = WineYears.hasWineYear(wine) ? WineYears.getWineYear(wine) : 0;
        return Math.max(0, WineYears.getDays(world) - y * DAYS_PER_YEAR);
    }

    public static int getEffectLevel(ItemStack wine, Level world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.max(0, Math.min(MAX_LEVEL, YEARS_PER_EFFECT_LEVEL > 0 ? age / YEARS_PER_EFFECT_LEVEL : 0));
    }

    public static int getEffectDuration(ItemStack wine, Level world) {
        int age = WineYears.getWineAge(wine, world);
        return Math.min(MAX_DURATION, Math.max(0, START_DURATION + DURATION_PER_YEAR * age));
    }

    public static void setWineYear(ItemStack wine, Level world) {
        int year = world != null ? WineYears.getYear(world) : 0;
        wine.m_41784_().m_128405_(TAG_YEAR, year);
        WineYears.refreshCached(wine, world);
    }

    public static void refreshCached(ItemStack wine, Level world) {
        int amplifier = WineYears.getEffectLevel(wine, world);
        int duration = WineYears.getEffectDuration(wine, world);
        CompoundTag tag = wine.m_41784_();
        tag.m_128405_(TAG_EFFECT_LEVEL, amplifier);
        tag.m_128405_(TAG_EFFECT_DURATION, duration);
    }

    public static int getWineYear(ItemStack wine) {
        return wine.m_41784_().m_128451_(TAG_YEAR);
    }

    public static boolean hasWineYear(ItemStack wine) {
        return wine.m_41784_().m_128441_(TAG_YEAR);
    }

    @PlatformOnly(value={"forge"})
    public static CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack.m_41783_() != null) {
            if (stack.m_41783_().m_128441_(TAG_YEAR)) {
                tag.m_128405_(TAG_YEAR, stack.m_41783_().m_128451_(TAG_YEAR));
            }
            if (stack.m_41783_().m_128441_(TAG_EFFECT_LEVEL)) {
                tag.m_128405_(TAG_EFFECT_LEVEL, stack.m_41783_().m_128451_(TAG_EFFECT_LEVEL));
            }
            if (stack.m_41783_().m_128441_(TAG_EFFECT_DURATION)) {
                tag.m_128405_(TAG_EFFECT_DURATION, stack.m_41783_().m_128451_(TAG_EFFECT_DURATION));
            }
        }
        return tag;
    }

    @PlatformOnly(value={"forge"})
    public static void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null) {
            if (nbt.m_128441_(TAG_YEAR)) {
                stack.m_41784_().m_128405_(TAG_YEAR, nbt.m_128451_(TAG_YEAR));
            }
            if (nbt.m_128441_(TAG_EFFECT_LEVEL)) {
                stack.m_41784_().m_128405_(TAG_EFFECT_LEVEL, nbt.m_128451_(TAG_EFFECT_LEVEL));
            }
            if (nbt.m_128441_(TAG_EFFECT_DURATION)) {
                stack.m_41784_().m_128405_(TAG_EFFECT_DURATION, nbt.m_128451_(TAG_EFFECT_DURATION));
            }
        }
    }
}

