/*
 * Decompiled with CFR 0.152.
 */
package sunbatheproductions28.guardribbits.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GuardRibbitEntity
extends AgeableMob
implements GeoEntity,
NeutralMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private static final RawAnimation GUARD = RawAnimation.begin().thenPlay("guard");
    private static final UniformInt angerTime = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.m_135353_(GuardRibbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private BlockPos homePosition;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public GuardRibbitEntity(EntityType<GuardRibbitEntity> entityType, Level level) {
        super(entityType, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((GuardRibbitEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createRibbitAttributes() {
        return GuardRibbitEntity.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.remainingPersistentAngerTime > 0) {
            --this.remainingPersistentAngerTime;
            if (this.remainingPersistentAngerTime == 0) {
                this.m_6925_(null);
            }
        }
    }

    public boolean m_7327_(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.m_147240_(0.5, Math.sin((double)this.m_146908_() * Math.PI / 180.0), -Math.cos((double)this.m_146908_() * Math.PI / 180.0));
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        }
        return super.m_7327_(target);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPatrolling(compound.m_128471_("Patrolling"));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Patrolling", this.isPatrolling());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        if (this.isAttacking()) {
            state.setAnimation(ATTACK);
        } else if (this.isGuarding()) {
            state.setAnimation(GUARD);
        } else if (state.isMoving()) {
            state.setAnimation(WALK);
        } else {
            state.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private boolean isAttacking() {
        return this.m_5448_() != null && this.f_20911_;
    }

    private boolean isGuarding() {
        return this.m_5448_() == null && !this.m_9236_().m_45971_(Mob.class, TargetingConditions.m_148353_(), (LivingEntity)this, this.m_20191_().m_82400_(10.0)).isEmpty();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PATROLLING, (Object)false);
    }

    public boolean isPatrolling() {
        return (Boolean)this.f_19804_.m_135370_(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.f_19804_.m_135381_(PATROLLING, (Object)patrolling);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            this.m_6925_(livingEntity.m_20148_());
            this.m_7870_(angerTime.m_214085_(this.f_19796_));
        }
        return super.m_6469_(source, amount);
    }

    public boolean defendsRibbitAgainst(LivingEntity lastHurtByMob) {
        return !(lastHurtByMob instanceof Player);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID arg0) {
        this.persistentAngerTarget = arg0;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int arg0) {
        this.remainingPersistentAngerTime = arg0;
    }

    public void m_6825_() {
        this.m_7870_(angerTime.m_214085_(this.f_19796_));
    }
}

