/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.behaviour.spouting;

import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.api.registry.SimpleRegistry;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public enum CauldronSpoutingBehavior implements BlockSpoutingBehaviour
{
    INSTANCE;

    public static final SimpleRegistry<Fluid, CauldronInfo> CAULDRON_INFO;

    @Override
    public int fillBlock(Level level, BlockPos pos, SpoutBlockEntity spout, FluidStack availableFluid, boolean simulate) {
        CauldronInfo info = CAULDRON_INFO.get(availableFluid.getFluid());
        if (info == null) {
            return 0;
        }
        if (availableFluid.getAmount() < info.amount) {
            return 0;
        }
        if (!simulate) {
            level.m_46597_(pos, info.cauldron);
        }
        return info.amount;
    }

    static {
        CAULDRON_INFO = (SimpleRegistry)Util.m_137537_(() -> {
            SimpleRegistry<FlowingFluid, CauldronInfo> registry = SimpleRegistry.create();
            registry.register(Fluids.f_76193_, new CauldronInfo(250, Blocks.f_152476_));
            registry.register(Fluids.f_76195_, new CauldronInfo(1000, Blocks.f_152477_));
            return registry;
        });
    }

    public record CauldronInfo(int amount, BlockState cauldron) {
        public CauldronInfo(int amount, Block block) {
            this(amount, block.m_49966_());
        }
    }
}

